/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.Expression;
import com.apple.foundationdb.relational.api.fluentsql.expression.FunctionLike;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.Operation;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class NumericFunction<N extends DataType.NumericType>
implements NumericExpressionTrait<N>,
FunctionLike<N> {
    @Nonnull
    private final Operation operator;
    @Nonnull
    private final ImmutableList<Expression<?>> args;
    @Nonnull
    private final N type;

    public NumericFunction(@Nonnull N type, @Nonnull Operation operator, @Nonnull List<Expression<?>> args) {
        this.operator = operator;
        this.args = ImmutableList.copyOf(args);
        this.type = type;
    }

    @Override
    @Nonnull
    public Iterable<Expression<?>> getArguments() {
        return this.args;
    }

    @Override
    @Nonnull
    public Operation getName() {
        return this.operator;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public N getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf((Object)this.operator) + "(" + this.args.stream().map(Object::toString).collect(Collectors.joining(",")) + ") : " + String.valueOf(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericFunction that = (NumericFunction)o;
        return this.operator == that.operator && Objects.equals(this.args, that.args) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.args, this.type});
    }
}

