/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.Literal;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericExpressionTrait;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class NumericLiteral<N extends Number, D extends DataType.NumericType>
implements Literal<N, D>,
NumericExpressionTrait<D> {
    @Nonnull
    private final D type;
    @Nullable
    private final N literal;

    public NumericLiteral(@Nonnull D type, @Nullable N literal) {
        this.type = type;
        this.literal = literal;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public D getType() {
        return this.type;
    }

    @Override
    @Nullable
    public N getValue() {
        return this.literal;
    }

    public String toString() {
        return this.literal == null ? "NULL" : String.valueOf(this.literal) + " : " + String.valueOf(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.literal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericLiteral that = (NumericLiteral)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.literal, that.literal);
    }
}

