/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFragment;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ParsingFragment<T extends DataType>
implements ExpressionFragment<T> {
    @Nonnull
    private final String fragment;
    @Nonnull
    private final T dataType;

    public ParsingFragment(@Nonnull T dataType, @Nonnull String fragment) {
        this.dataType = dataType;
        this.fragment = fragment;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    @Nonnull
    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return "{" + this.fragment + "} : " + String.valueOf(this.dataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsingFragment that = (ParsingFragment)o;
        return Objects.equals(this.fragment, that.fragment) && Objects.equals(this.dataType, that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.dataType);
    }
}

