/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.Literal;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class StringLiteral
implements Literal<String, DataType.StringType> {
    @Nullable
    private final String literal;
    @Nonnull
    private final DataType.StringType type;

    public StringLiteral(@Nonnull DataType.StringType type, @Nullable String literal) {
        this.type = type;
        this.literal = literal;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public DataType.StringType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.literal;
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal + " : " + String.valueOf(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.literal, this.type);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)other;
        return Objects.equals(this.literal, that.literal) && Objects.equals(this.type, that.type);
    }
}

