/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.fluentsql.expression.details.Mixins;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class UserDefinedField<T extends DataType>
implements Field<T> {
    @Nonnull
    private final String name;
    @Nonnull
    private final ImmutableList<String> parts;
    @Nonnull
    private final T type;
    @Nonnull
    private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

    public UserDefinedField(@Nonnull T type, @Nonnull Iterable<String> parts) {
        this.name = Iterables.getLast(parts);
        this.parts = ImmutableList.copyOf(parts);
        this.type = type;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public Iterable<String> getParts() {
        return this.parts;
    }

    @Override
    @Nonnull
    public T getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Field<?> subField(@Nonnull String part) {
        return this.subField(DataType.UnknownType.instance(), part);
    }

    @Nonnull
    public Field<?> subField(@Nonnull DataType type, @Nonnull String name) {
        List<String> newFields = Streams.concat(this.parts.stream(), Stream.of(name)).collect(Collectors.toUnmodifiableList());
        return new UserDefinedField<DataType>(type, newFields);
    }

    @Override
    @Nonnull
    public Mixins.BooleanField asBoolean() {
        this.expectingType(DataType.Code.BOOLEAN);
        return Field.super.asBoolean();
    }

    @Override
    @Nonnull
    public Mixins.IntField asInt() {
        this.expectingType(DataType.Code.INTEGER);
        return Field.super.asInt();
    }

    @Override
    @Nonnull
    public Mixins.LongField asLong() {
        this.expectingType(DataType.Code.LONG);
        return Field.super.asLong();
    }

    @Override
    @Nonnull
    public Mixins.FloatField asFloat() {
        this.expectingType(DataType.Code.FLOAT);
        return Field.super.asFloat();
    }

    @Override
    @Nonnull
    public Mixins.DoubleField asDouble() {
        this.expectingType(DataType.Code.DOUBLE);
        return Field.super.asDouble();
    }

    @Override
    @Nonnull
    public Mixins.StringField asString() {
        this.expectingType(DataType.Code.STRING);
        return Field.super.asString();
    }

    private void expectingType(@Nonnull DataType.Code code) {
        if (((DataType)this.type).getCode() != DataType.Code.UNKNOWN && !((DataType)this.type).getCode().equals((Object)code)) {
            throw new RelationalException("Type mismatch, expected type '" + code.name() + "', actual type '" + ((DataType)this.type).getCode().name() + "'", ErrorCode.DATATYPE_MISMATCH).toUncheckedWrappedException();
        }
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Field)) {
            return false;
        }
        Field otherFieldImpl = (Field)other;
        return this.parts.equals(otherFieldImpl.getParts()) && this.getType().equals(otherFieldImpl.getType());
    }

    public String toString() {
        return String.join((CharSequence)".", this.parts) + " : " + String.valueOf(this.type);
    }

    private int computeHashCode() {
        return Objects.hash(this.parts, this.getType());
    }
}

