/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression.details;

import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFragment;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericExpressionTrait;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Mixins {
    @Nonnull
    public static BooleanField asBoolean(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new BooleanField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.BooleanType getType() {
                return isNullable ? DataType.BooleanType.nullable() : DataType.BooleanType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static IntField asInt(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new IntField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.IntegerType getType() {
                return isNullable ? DataType.IntegerType.nullable() : DataType.IntegerType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static LongField asLong(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new LongField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.LongType getType() {
                return isNullable ? DataType.LongType.nullable() : DataType.LongType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static FloatField asFloat(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new FloatField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.FloatType getType() {
                return isNullable ? DataType.FloatType.nullable() : DataType.FloatType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static DoubleField asDouble(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new DoubleField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.DoubleType getType() {
                return isNullable ? DataType.DoubleType.nullable() : DataType.DoubleType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static StringField asString(final @Nonnull Field<?> mixin, final boolean isNullable) {
        return new StringField(){
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

            @Override
            @Nonnull
            public Iterable<String> getParts() {
                return mixin.getParts();
            }

            @Override
            @Nonnull
            public Field<?> subField(@Nonnull String part) {
                return mixin.subField(part);
            }

            @Override
            @Nonnull
            public String getName() {
                return mixin.getName();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.StringType getType() {
                return isNullable ? DataType.StringType.nullable() : DataType.StringType.notNullable();
            }

            private int computeHashCode() {
                return mixin.hashCode();
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                return this.equalsInternal(other);
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }
        };
    }

    @Nonnull
    public static BooleanExpressionFragment asBoolean(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new BooleanExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.BooleanType getType() {
                return isNullable ? DataType.BooleanType.nullable() : DataType.BooleanType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    @Nonnull
    public static IntExpressionFragment asInt(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new IntExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.IntegerType getType() {
                return isNullable ? DataType.IntegerType.nullable() : DataType.IntegerType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    @Nonnull
    public static LongExpressionFragment asLong(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new LongExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.LongType getType() {
                return isNullable ? DataType.LongType.nullable() : DataType.LongType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    @Nonnull
    public static FloatExpressionFragment asFloat(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new FloatExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.FloatType getType() {
                return isNullable ? DataType.FloatType.nullable() : DataType.FloatType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    @Nonnull
    public static DoubleExpressionFragment asDouble(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new DoubleExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.DoubleType getType() {
                return isNullable ? DataType.DoubleType.nullable() : DataType.DoubleType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    @Nonnull
    public static StringExpressionFragment asString(final ExpressionFragment<?> mixin, final boolean isNullable) {
        return new StringExpressionFragment(){

            @Override
            @Nonnull
            public String getFragment() {
                return mixin.getFragment();
            }

            @Override
            @Nullable
            public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
                return mixin.accept(visitor, context);
            }

            @Override
            public DataType.StringType getType() {
                return isNullable ? DataType.StringType.nullable() : DataType.StringType.notNullable();
            }

            public String toString() {
                return "(" + String.valueOf(mixin) + ") : " + String.valueOf(this.getType());
            }

            public boolean equals(Object obj) {
                return this.equalsInternal(obj);
            }

            public int hashCode() {
                return mixin.hashCode();
            }
        };
    }

    public static interface DoubleExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.DoubleType>,
    NumericExpressionTrait<DataType.DoubleType> {
        @Override
        default public DataType.DoubleType getType() {
            return DataType.DoubleType.nullable();
        }
    }

    public static interface FloatExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.FloatType>,
    NumericExpressionTrait<DataType.FloatType> {
        @Override
        default public DataType.FloatType getType() {
            return DataType.FloatType.nullable();
        }
    }

    public static interface LongExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.LongType>,
    NumericExpressionTrait<DataType.LongType> {
        @Override
        default public DataType.LongType getType() {
            return DataType.LongType.nullable();
        }
    }

    public static interface IntExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.IntegerType>,
    NumericExpressionTrait<DataType.IntegerType> {
        @Override
        default public DataType.IntegerType getType() {
            return DataType.IntegerType.nullable();
        }
    }

    public static interface StringExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.StringType> {
        @Override
        default public DataType.StringType getType() {
            return DataType.StringType.nullable();
        }
    }

    public static interface BooleanExpressionFragment
    extends ExpressionFragmentEqualityTrait<DataType.BooleanType>,
    BooleanExpressionTrait {
        @Override
        default public DataType.BooleanType getType() {
            return DataType.BooleanType.nullable();
        }
    }

    public static interface ExpressionFragmentEqualityTrait<T extends DataType>
    extends ExpressionFragment<T> {
        default public boolean equalsInternal(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof ExpressionFragment) {
                ExpressionFragment other = (ExpressionFragment)obj;
                return this.getType().equals(other.getType()) && this.getFragment().equals(other.getFragment());
            }
            return false;
        }
    }

    public static interface DoubleField
    extends FieldEqualityTrait<DataType.DoubleType>,
    NumericExpressionTrait<DataType.DoubleType> {
        @Override
        default public DataType.DoubleType getType() {
            return DataType.DoubleType.nullable();
        }
    }

    public static interface FloatField
    extends FieldEqualityTrait<DataType.FloatType>,
    NumericExpressionTrait<DataType.FloatType> {
        @Override
        default public DataType.FloatType getType() {
            return DataType.FloatType.nullable();
        }
    }

    public static interface LongField
    extends FieldEqualityTrait<DataType.LongType>,
    NumericExpressionTrait<DataType.LongType> {
        @Override
        default public DataType.LongType getType() {
            return DataType.LongType.nullable();
        }
    }

    public static interface IntField
    extends FieldEqualityTrait<DataType.IntegerType>,
    NumericExpressionTrait<DataType.IntegerType> {
        @Override
        default public DataType.IntegerType getType() {
            return DataType.IntegerType.nullable();
        }
    }

    public static interface StringField
    extends FieldEqualityTrait<DataType.StringType> {
    }

    public static interface BooleanField
    extends FieldEqualityTrait<DataType.BooleanType>,
    BooleanExpressionTrait {
    }

    public static interface FieldEqualityTrait<T extends DataType>
    extends Field<T> {
        default public boolean equalsInternal(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Field) {
                Field other = (Field)obj;
                return this.getType().equals(other.getType()) && this.getParts().equals(other.getParts());
            }
            return false;
        }
    }
}

