/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.metadata;

import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class DataType {
    @Nonnull
    private static final Map<Code, Integer> typeCodeJdbcTypeMap = new HashMap<Code, Integer>();
    private final boolean isNullable;
    private final boolean isPrimitive;
    @Nonnull
    private final Code code;

    private DataType(boolean isNullable, boolean isPrimitive, @Nonnull Code code) {
        this.isNullable = isNullable;
        this.isPrimitive = isPrimitive;
        this.code = code;
    }

    @Nonnull
    public Code getCode() {
        return this.code;
    }

    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="there is protection against nulls")
    public int getJdbcSqlCode() {
        return typeCodeJdbcTypeMap.get((Object)Objects.requireNonNull(this.getCode()));
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public abstract boolean isResolved();

    @Nonnull
    public abstract DataType withNullable(boolean var1);

    @Nonnull
    public abstract DataType resolve(@Nonnull Map<String, Named> var1);

    @Nonnull
    public static DataType getDataTypeFromObject(@Nullable Object obj) {
        try {
            if (obj == null) {
                return Primitives.NULL.type();
            }
            if (obj instanceof Long) {
                return Primitives.LONG.type();
            }
            if (obj instanceof Integer) {
                return Primitives.INTEGER.type();
            }
            if (obj instanceof Boolean) {
                return Primitives.BOOLEAN.type();
            }
            if (obj instanceof byte[]) {
                return Primitives.BYTES.type();
            }
            if (obj instanceof Float) {
                return Primitives.FLOAT.type();
            }
            if (obj instanceof Double) {
                return Primitives.DOUBLE.type();
            }
            if (obj instanceof String) {
                return Primitives.STRING.type();
            }
            if (obj instanceof UUID) {
                return Primitives.UUID.type();
            }
            if (obj instanceof RelationalStruct) {
                return ((RelationalStruct)obj).getMetaData().getRelationalDataType();
            }
            if (obj instanceof RelationalArray) {
                return ((RelationalArray)obj).getMetaData().asRelationalType();
            }
            throw new IllegalStateException("Unexpected object type: " + obj.getClass().getName());
        }
        catch (SQLException e) {
            throw new RelationalException(e).toUncheckedWrappedException();
        }
    }

    static {
        typeCodeJdbcTypeMap.put(Code.BOOLEAN, 16);
        typeCodeJdbcTypeMap.put(Code.LONG, -5);
        typeCodeJdbcTypeMap.put(Code.INTEGER, 4);
        typeCodeJdbcTypeMap.put(Code.FLOAT, 6);
        typeCodeJdbcTypeMap.put(Code.DOUBLE, 8);
        typeCodeJdbcTypeMap.put(Code.STRING, 12);
        typeCodeJdbcTypeMap.put(Code.ENUM, 1111);
        typeCodeJdbcTypeMap.put(Code.UUID, 1111);
        typeCodeJdbcTypeMap.put(Code.BYTES, -2);
        typeCodeJdbcTypeMap.put(Code.VERSION, -2);
        typeCodeJdbcTypeMap.put(Code.STRUCT, 2002);
        typeCodeJdbcTypeMap.put(Code.ARRAY, 2003);
        typeCodeJdbcTypeMap.put(Code.NULL, 0);
    }

    @Nonnull
    public static enum Code {
        BOOLEAN,
        LONG,
        INTEGER,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        VERSION,
        ENUM,
        UUID,
        STRUCT,
        ARRAY,
        UNKNOWN,
        NULL;

    }

    @Nonnull
    public static enum Primitives {
        BOOLEAN(BooleanType.notNullable()),
        LONG(LongType.notNullable()),
        INTEGER(IntegerType.notNullable()),
        FLOAT(FloatType.notNullable()),
        DOUBLE(DoubleType.notNullable()),
        STRING(StringType.notNullable()),
        BYTES(BytesType.notNullable()),
        VERSION(VersionType.notNullable()),
        UUID(UuidType.notNullable()),
        NULLABLE_BOOLEAN(BooleanType.nullable()),
        NULLABLE_LONG(LongType.nullable()),
        NULLABLE_INTEGER(IntegerType.nullable()),
        NULLABLE_FLOAT(FloatType.nullable()),
        NULLABLE_DOUBLE(DoubleType.nullable()),
        NULLABLE_STRING(StringType.nullable()),
        NULLABLE_BYTES(BytesType.nullable()),
        NULLABLE_VERSION(VersionType.nullable()),
        NULLABLE_UUID(UuidType.nullable()),
        NULL(NullType.INSTANCE);

        @Nonnull
        private final DataType datatype;

        private Primitives(DataType datatype) {
            this.datatype = datatype;
        }

        @Nonnull
        public DataType type() {
            return this.datatype;
        }
    }

    public static final class StructType
    extends DataType
    implements Named,
    CompositeType {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private final List<Field> fields;
        @Nonnull
        private final String name;
        @Nonnull
        private final Supplier<Boolean> resolvedSupplier = Suppliers.memoize(this::calculateResolved);

        private StructType(@Nonnull String name, boolean isNullable, @Nonnull List<Field> fields) {
            super(isNullable, false, Code.STRUCT);
            this.name = name;
            this.fields = ImmutableList.copyOf(fields);
        }

        @Nonnull
        public List<Field> getFields() {
            return this.fields;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public static StructType from(@Nonnull String name, @Nonnull List<Field> fields, boolean isNullable) {
            return new StructType(name, isNullable, fields);
        }

        @Override
        @Nonnull
        public StructType withNullable(boolean isNullable) {
            if (isNullable == this.isNullable()) {
                return this;
            }
            return new StructType(this.name, isNullable, this.fields);
        }

        private boolean calculateResolved() {
            for (Field column : this.fields) {
                if (column.type.isResolved()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isResolved() {
            return this.resolvedSupplier.get();
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            if (this.isResolved()) {
                return this;
            }
            ImmutableList.Builder resolvedFields = ImmutableList.builder();
            for (Field field : this.fields) {
                resolvedFields.add(Field.from(field.name, field.getType().resolve(resolutionMap), field.index));
            }
            return StructType.from(this.name, (List<Field>)((Object)resolvedFields.build()), this.isNullable());
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable(), this.name, this.fields});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StructType)) {
                return false;
            }
            StructType otherStructType = (StructType)other;
            return this.isNullable() == otherStructType.isNullable() && this.name.equals(otherStructType.name) && this.fields.equals(otherStructType.fields);
        }

        @Override
        public boolean hasIdenticalStructure(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StructType)) {
                return false;
            }
            StructType otherStructType = (StructType)other;
            List<Field> fields = this.getFields();
            List<Field> otherFields = otherStructType.getFields();
            if (this.isNullable() != otherStructType.isNullable() || fields.size() != otherFields.size()) {
                return false;
            }
            for (int i = 0; i < fields.size(); ++i) {
                if (!fields.get(i).getName().equals(otherFields.get(i).getName()) || fields.get(i).getIndex() != otherFields.get(i).getIndex()) {
                    return false;
                }
                DataType type = fields.get(i).getType();
                if (!(type instanceof CompositeType ? !((CompositeType)((Object)type)).hasIdenticalStructure(otherFields.get(i).getType()) : !type.equals(otherStructType.getFields().get(i).getType()))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.name.substring(0, Math.min(this.name.length(), 5)) + " { " + this.fields.stream().map(field -> field.getName() + ":" + String.valueOf(field.getType())).collect(Collectors.joining(",")) + " } ";
        }

        public static class Field {
            @Nonnull
            private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
            @Nonnull
            private final String name;
            @Nonnull
            private final DataType type;
            private final int index;

            private Field(@Nonnull String name, @Nonnull DataType type, int index) {
                Assert.thatUnchecked(index >= 0);
                this.name = name;
                this.type = type;
                this.index = index;
            }

            @Nonnull
            public static Field from(@Nonnull String name, @Nonnull DataType type, int index) {
                return new Field(name, type, index);
            }

            @Nonnull
            public String getName() {
                return this.name;
            }

            @Nonnull
            public DataType getType() {
                return this.type;
            }

            public int getIndex() {
                return this.index;
            }

            private int computeHashCode() {
                return Objects.hash(this.name, this.index, this.type);
            }

            public int hashCode() {
                return this.hashCodeSupplier.get();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Field)) {
                    return false;
                }
                Field otherField = (Field)other;
                return this.name.equals(otherField.name) && this.index == otherField.index && this.type.equals(otherField.type);
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static final class ArrayType
    extends DataType
    implements CompositeType {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private final DataType elementType;

        private ArrayType(boolean isNullable, @Nonnull DataType elementType) {
            super(isNullable, false, Code.ARRAY);
            this.elementType = elementType;
        }

        @Nonnull
        public static ArrayType from(@Nonnull DataType type) {
            return ArrayType.from(type, false);
        }

        @Nonnull
        public static ArrayType from(@Nonnull DataType type, boolean isNullable) {
            return new ArrayType(isNullable, type);
        }

        @Nonnull
        public DataType getElementType() {
            return this.elementType;
        }

        @Override
        @Nonnull
        public ArrayType withNullable(boolean isNullable) {
            if (isNullable == this.isNullable()) {
                return this;
            }
            return new ArrayType(isNullable, this.elementType);
        }

        @Override
        public boolean isResolved() {
            return this.elementType.isResolved();
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            if (this.isResolved()) {
                return this;
            }
            return ArrayType.from(this.elementType.resolve(resolutionMap));
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable(), this.elementType});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArrayType)) {
                return false;
            }
            ArrayType otherArrayType = (ArrayType)other;
            return this.isNullable() == otherArrayType.isNullable() && this.elementType.equals(otherArrayType.elementType);
        }

        public String toString() {
            return "[" + String.valueOf(this.elementType) + "]" + (this.isNullable() ? " \u222a \u2205" : "");
        }

        @Override
        public boolean hasIdenticalStructure(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArrayType)) {
                return false;
            }
            ArrayType otherArrayType = (ArrayType)other;
            if (this.isNullable() != otherArrayType.isNullable()) {
                return false;
            }
            if (this.elementType instanceof CompositeType) {
                return ((CompositeType)((Object)this.elementType)).hasIdenticalStructure(otherArrayType.elementType);
            }
            return this.elementType.equals(otherArrayType.elementType);
        }
    }

    public static final class UnknownType
    extends DataType {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private static final UnknownType INSTANCE = new UnknownType();

        private UnknownType() {
            super(false, false, Code.UNKNOWN);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            throw new RelationalException("Attempt to set nullability on unknown type", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            throw new RelationalException("Can not resolve unknown type", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Nonnull
        public static UnknownType instance() {
            return INSTANCE;
        }

        public String toString() {
            return "???";
        }
    }

    public static final class UnresolvedType
    extends DataType
    implements Named {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private final String name;

        private UnresolvedType(@Nonnull String name, boolean isNullable) {
            super(isNullable, false, Code.UNKNOWN);
            this.name = name;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable == this.isNullable()) {
                return this;
            }
            return new UnresolvedType(this.name, isNullable);
        }

        @Nonnull
        public static UnresolvedType of(@Nonnull String name, boolean isNullable) {
            return new UnresolvedType(name, isNullable);
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            Assert.thatUnchecked(resolutionMap.containsKey(this.name), ErrorCode.INTERNAL_ERROR, "Could not find type %s", this.name);
            return ((DataType)((Object)resolutionMap.get(this.name))).withNullable(this.isNullable());
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable(), this.name});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnresolvedType)) {
                return false;
            }
            UnresolvedType otherUnresolvedType = (UnresolvedType)other;
            return this.isNullable() == otherUnresolvedType.isNullable() && this.name.equals(otherUnresolvedType.name);
        }
    }

    public static final class EnumType
    extends DataType
    implements Named {
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        @Nonnull
        private final String name;
        @Nonnull
        private final List<EnumValue> values;

        public String toString() {
            return "enum(" + this.name + "){" + this.values.stream().map(EnumValue::toString).collect(Collectors.joining(",")) + "}";
        }

        private EnumType(@Nonnull String name, @Nonnull List<EnumValue> values, boolean isNullable) {
            super(isNullable, true, Code.ENUM);
            this.name = name;
            this.values = values;
        }

        @Nonnull
        public List<EnumValue> getValues() {
            return this.values;
        }

        @Nonnull
        public static EnumType from(@Nonnull String name, @Nonnull List<EnumValue> values, boolean isNullable) {
            Assert.thatUnchecked(!values.isEmpty());
            Assert.thatUnchecked(!name.isEmpty());
            return new EnumType(name, values, isNullable);
        }

        @Override
        @Nonnull
        public EnumType withNullable(boolean isNullable) {
            if (isNullable == this.isNullable()) {
                return this;
            }
            return new EnumType(this.getName(), this.values, isNullable);
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable(), this.values});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnumType)) {
                return false;
            }
            EnumType otherEnumType = (EnumType)other;
            return this.isNullable() == otherEnumType.isNullable() && this.name.equals(otherEnumType.name) && this.values.equals(otherEnumType.values);
        }

        public static class EnumValue {
            @Nonnull
            private final String name;
            private final int number;

            private EnumValue(@Nonnull String name, int number) {
                this.name = name;
                this.number = number;
            }

            @Nonnull
            public static EnumValue of(@Nonnull String name, int number) {
                return new EnumValue(name, number);
            }

            @Nonnull
            public String getName() {
                return this.name;
            }

            public int getNumber() {
                return this.number;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static final class NullType
    extends DataType {
        @Nonnull
        private static final NullType INSTANCE = new NullType();
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private NullType() {
            super(true, true, Code.NULL);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULL.type();
            }
            throw new RelationalException("NULL type cannot be non-nullable", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static NullType nullable() {
            return INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NullType)) {
                return false;
            }
            NullType otherUuidType = (NullType)other;
            return this.isNullable() == otherUuidType.isNullable();
        }

        public String toString() {
            return "\u2205";
        }
    }

    public static final class UuidType
    extends DataType {
        @Nonnull
        private static final UuidType NOT_NULLABLE_INSTANCE = new UuidType(false);
        @Nonnull
        private static final UuidType NULLABLE_INSTANCE = new UuidType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private UuidType(boolean isNullable) {
            super(isNullable, true, Code.UUID);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_UUID.type();
            }
            return Primitives.UUID.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static UuidType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static UuidType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UuidType)) {
                return false;
            }
            UuidType otherUuidType = (UuidType)other;
            return this.isNullable() == otherUuidType.isNullable();
        }

        public String toString() {
            return "uuid" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static final class VersionType
    extends DataType {
        @Nonnull
        private static final VersionType NOT_NULLABLE_INSTANCE = new VersionType(false);
        @Nonnull
        private static final VersionType NULLABLE_INSTANCE = new VersionType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private VersionType(boolean isNullable) {
            super(isNullable, true, Code.VERSION);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_VERSION.type();
            }
            return Primitives.VERSION.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static VersionType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static VersionType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionType)) {
                return false;
            }
            VersionType otherVersionType = (VersionType)other;
            return this.isNullable() == otherVersionType.isNullable();
        }

        public String toString() {
            return "version" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static final class BytesType
    extends DataType {
        @Nonnull
        private static final BytesType NOT_NULLABLE_INSTANCE = new BytesType(false);
        @Nonnull
        private static final BytesType NULLABLE_INSTANCE = new BytesType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private BytesType(boolean isNullable) {
            super(isNullable, true, Code.BYTES);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_BYTES.type();
            }
            return Primitives.BYTES.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static BytesType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static BytesType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BytesType)) {
                return false;
            }
            BytesType otherBytesType = (BytesType)other;
            return this.isNullable() == otherBytesType.isNullable();
        }

        public String toString() {
            return "bytes" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static final class StringType
    extends DataType {
        @Nonnull
        private static final StringType NOT_NULLABLE_INSTANCE = new StringType(false);
        @Nonnull
        private static final StringType NULLABLE_INSTANCE = new StringType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private StringType(boolean isNullable) {
            super(isNullable, true, Code.STRING);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_STRING.type();
            }
            return Primitives.STRING.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringType)) {
                return false;
            }
            StringType otherStringType = (StringType)other;
            return this.isNullable() == otherStringType.isNullable();
        }

        public String toString() {
            return "string" + (this.isNullable() ? " \u222a \u2205" : "");
        }

        @Nonnull
        public static StringType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static StringType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }
    }

    public static final class DoubleType
    extends NumericType {
        @Nonnull
        private static final DoubleType NOT_NULLABLE_INSTANCE = new DoubleType(false);
        @Nonnull
        private static final DoubleType NULLABLE_INSTANCE = new DoubleType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private DoubleType(boolean isNullable) {
            super(isNullable, true, Code.DOUBLE);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_DOUBLE.type();
            }
            return Primitives.DOUBLE.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static DoubleType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static DoubleType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DoubleType)) {
                return false;
            }
            DoubleType otherDoubleType = (DoubleType)other;
            return this.isNullable() == otherDoubleType.isNullable();
        }

        public String toString() {
            return "double" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static final class FloatType
    extends NumericType {
        @Nonnull
        private static final FloatType NOT_NULLABLE_INSTANCE = new FloatType(false);
        @Nonnull
        private static final FloatType NULLABLE_INSTANCE = new FloatType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private FloatType(boolean isNullable) {
            super(isNullable, true, Code.FLOAT);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_FLOAT.type();
            }
            return Primitives.FLOAT.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FloatType)) {
                return false;
            }
            FloatType otherFloatType = (FloatType)other;
            return this.isNullable() == otherFloatType.isNullable();
        }

        public String toString() {
            return "float" + (this.isNullable() ? " \u222a \u2205" : "");
        }

        @Nonnull
        public static FloatType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static FloatType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }
    }

    public static final class LongType
    extends NumericType {
        @Nonnull
        private static final LongType NOT_NULLABLE_INSTANCE = new LongType(false);
        @Nonnull
        private static final LongType NULLABLE_INSTANCE = new LongType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private LongType(boolean isNullable) {
            super(isNullable, true, Code.LONG);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_LONG.type();
            }
            return Primitives.LONG.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LongType)) {
                return false;
            }
            LongType otherLongType = (LongType)other;
            return this.isNullable() == otherLongType.isNullable();
        }

        public String toString() {
            return "long" + (this.isNullable() ? " \u222a \u2205" : "");
        }

        @Nonnull
        public static LongType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static LongType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }
    }

    public static final class IntegerType
    extends NumericType {
        @Nonnull
        private static final IntegerType NOT_NULLABLE_INSTANCE = new IntegerType(false);
        @Nonnull
        private static final IntegerType NULLABLE_INSTANCE = new IntegerType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private IntegerType(boolean isNullable) {
            super(isNullable, true, Code.INTEGER);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_INTEGER.type();
            }
            return Primitives.INTEGER.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static IntegerType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static IntegerType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntegerType)) {
                return false;
            }
            IntegerType otherIntegerType = (IntegerType)other;
            return this.isNullable() == otherIntegerType.isNullable();
        }

        public String toString() {
            return "int" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static final class BooleanType
    extends DataType {
        @Nonnull
        private static final BooleanType NOT_NULLABLE_INSTANCE = new BooleanType(false);
        @Nonnull
        private static final BooleanType NULLABLE_INSTANCE = new BooleanType(true);
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier = Suppliers.memoize(this::computeHashCode);

        private BooleanType(boolean isNullable) {
            super(isNullable, true, Code.BOOLEAN);
        }

        @Override
        @Nonnull
        public DataType withNullable(boolean isNullable) {
            if (isNullable) {
                return Primitives.NULLABLE_BOOLEAN.type();
            }
            return Primitives.BOOLEAN.type();
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        @Nonnull
        public DataType resolve(@Nonnull Map<String, Named> resolutionMap) {
            return this;
        }

        @Nonnull
        public static BooleanType nullable() {
            return NULLABLE_INSTANCE;
        }

        @Nonnull
        public static BooleanType notNullable() {
            return NOT_NULLABLE_INSTANCE;
        }

        private int computeHashCode() {
            return Objects.hash(new Object[]{this.getCode(), this.isNullable()});
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BooleanType)) {
                return false;
            }
            BooleanType otherBooleanType = (BooleanType)other;
            return this.isNullable() == otherBooleanType.isNullable();
        }

        public String toString() {
            return "boolean" + (this.isNullable() ? " \u222a \u2205" : "");
        }
    }

    public static abstract class NumericType
    extends DataType {
        private NumericType(boolean isNullable, boolean isPrimitive, @Nonnull Code code) {
            super(isNullable, isPrimitive, code);
        }
    }

    public static interface CompositeType {
        default public boolean hasIdenticalStructure(Object object) {
            return this.equals(object);
        }
    }

    public static interface Named {
        @Nonnull
        public String getName();
    }
}

