/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.metrics;

import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.util.Supplier;
import java.util.Locale;
import javax.annotation.Nonnull;

public interface MetricCollector {
    public void increment(@Nonnull RelationalMetric.RelationalCount var1);

    public <T> T clock(@Nonnull RelationalMetric.RelationalEvent var1, Supplier<T> var2) throws RelationalException;

    default public double getAverageTimeMicrosForEvent(@Nonnull RelationalMetric.RelationalEvent event) throws RelationalException {
        throw new RelationalException(String.format(Locale.ROOT, "Requested event metric: %s is not in the collector", event.title()), ErrorCode.INTERNAL_ERROR);
    }

    default public long getCountsForCounter(@Nonnull RelationalMetric.RelationalCount count) throws RelationalException {
        throw new RelationalException(String.format(Locale.ROOT, "Requested count metric: %s is not in the collector", count.title()), ErrorCode.INTERNAL_ERROR);
    }

    default public boolean hasCounter(@Nonnull RelationalMetric.RelationalCount count) {
        return false;
    }

    default public void flush() {
    }
}

