/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.metrics;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalMetric {
    private static final String RELATIONAL_TITLE_PREFIX = "Relational";
    private static final String RELATIONAL_LOG_PREFIX = "relational_";

    public static enum RelationalCount implements StoreTimer.Count
    {
        PLAN_CACHE_PRIMARY_MISS("primary cache miss", false),
        PLAN_CACHE_SECONDARY_MISS("secondary cache miss", false),
        PLAN_CACHE_TERTIARY_MISS("tertiary cache miss", false),
        PLAN_CACHE_TERTIARY_HIT("cache hit", false),
        CONTINUATION_ACCEPTED("continuation accepted", false),
        CONTINUATION_REJECTED("continuation rejected", false),
        CONTINUATION_DOWN_LEVEL("continuation accepted from down-level plan serialization mode", false);

        private final String title;
        private final boolean isSize;
        private final String logKey;

        private RelationalCount(String title, boolean isSize) {
            this.title = "Relational " + title;
            this.logKey = RelationalMetric.RELATIONAL_LOG_PREFIX + StoreTimer.Count.super.logKey();
            this.isSize = isSize;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public boolean isDelayedUntilCommit() {
            return false;
        }

        @Override
        public boolean isSize() {
            return this.isSize;
        }

        @Override
        public String logKey() {
            return this.logKey;
        }
    }

    public static enum RelationalEvent implements StoreTimer.Event
    {
        LEX_PARSE("lex and parse query"),
        NORMALIZE_QUERY("normalize the query"),
        GENERATE_LOGICAL_PLAN("generate logical plan for a query"),
        GENERATE_CONTINUED_PLAN("generate plan from continuation"),
        CACHE_LOOKUP("lookup in the cache"),
        OPTIMIZE_PLAN("optimize the plan"),
        TOTAL_GET_PLAN_QUERY("get the physical plan"),
        EXECUTE_RECORD_QUERY_PLAN("execute the record query plan"),
        CREATE_RESULT_SET_ITERATOR("create result set iterator"),
        TOTAL_EXECUTE_QUERY("execution phase of the query"),
        TOTAL_PROCESS_QUERY("process the query");

        private final String title;
        private final String logKey;

        private RelationalEvent(String title) {
            this.title = "Relational " + title;
            this.logKey = RelationalMetric.RELATIONAL_LOG_PREFIX + StoreTimer.Event.super.logKey();
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public String logKey() {
            return this.logKey;
        }
    }
}

