/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.options;

import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.options.OptionContract;
import com.apple.foundationdb.relational.api.options.OptionContractWithConversion;
import com.apple.foundationdb.relational.api.options.TypeContract;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionContract<T>
implements OptionContract,
OptionContractWithConversion<Collection<T>> {
    @Nonnull
    private final TypeContract<T> elementContract;

    public CollectionContract(@Nonnull TypeContract<T> elementContract) {
        this.elementContract = elementContract;
    }

    @Override
    public void validate(Options.Name name, Object value) throws SQLException {
        if (!(value instanceof Collection)) {
            throw new SQLException("Option " + String.valueOf((Object)name) + " should be of a collection type instead of " + value.getClass().getName(), ErrorCode.INVALID_PARAMETER.getErrorCode());
        }
        try {
            Collection collectionValue = (Collection)value;
            for (Object element : collectionValue) {
                this.elementContract.validate(name, element);
            }
        }
        catch (SQLException err) {
            throw new SQLException("Element of collection option " + String.valueOf((Object)name) + " violated contract: " + err.getMessage(), err.getSQLState(), err);
        }
    }

    @Override
    @Nullable
    public Collection<T> fromString(String valueAsString) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        for (String split : valueAsString.split(",")) {
            String trimmedElementString = split.trim();
            results.add(this.elementContract.fromString(trimmedElementString));
        }
        return Collections.unmodifiableList(results);
    }
}

