/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.options;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.options.OptionContract;
import java.sql.SQLException;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class RangeContract<T extends Comparable<T>>
implements OptionContract {
    private final T min;
    private final T max;

    private RangeContract(T min2, T max) {
        if (min2 == null) {
            throw new IllegalArgumentException("RangeContract: Min is null");
        }
        this.min = min2;
        if (max == null) {
            throw new IllegalArgumentException("RangeContract: Max is null");
        }
        if (min2.compareTo(max) > 0) {
            throw new IllegalArgumentException("RangeContract: Min is not <= Max");
        }
        this.max = max;
    }

    @Override
    public void validate(Options.Name name, Object value) throws SQLException {
        Comparable val = (Comparable)value;
        if (this.min.compareTo((Comparable)val) > 0 || this.max.compareTo((Comparable)val) < 0) {
            throw new SQLException("Option " + String.valueOf((Object)name) + " should be in range [" + String.valueOf(this.min) + ", " + String.valueOf(this.max) + "] but is " + String.valueOf(value), ErrorCode.INVALID_PARAMETER.getErrorCode());
        }
    }

    @Nonnull
    public static <T extends Comparable<T>> RangeContract<T> of(@Nonnull T min2, @Nonnull T max) {
        return new RangeContract<T>(min2, max);
    }
}

