/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.options;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.options.OptionContract;
import com.apple.foundationdb.relational.api.options.OptionContractWithConversion;
import java.sql.SQLException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TypeContract<T>
implements OptionContract,
OptionContractWithConversion<T> {
    @Nonnull
    private static final TypeContract<Boolean> BOOLEAN_TYPE = new TypeContract<Boolean>(Boolean.class, Boolean::parseBoolean, false);
    @Nonnull
    private static final TypeContract<Integer> INTEGER_TYPE = new TypeContract<Integer>(Integer.class, Integer::parseInt, false);
    @Nonnull
    private static final TypeContract<Long> LONG_TYPE = new TypeContract<Long>(Long.class, Long::parseLong, false);
    @Nonnull
    private static final TypeContract<String> STRING_TYPE = new TypeContract<String>(String.class, Function.identity(), false);
    @Nonnull
    private static final TypeContract<String> NULLABLE_STRING_TYPE = new TypeContract<String>(String.class, Function.identity(), true);
    @Nonnull
    private final Class<T> clazz;
    @Nonnull
    private final Function<String, T> fromStringFunction;
    private final boolean nullable;

    private TypeContract(@Nonnull Class<T> clazz, @Nonnull Function<String, T> fromStringFunction, boolean nullable) {
        this.clazz = clazz;
        this.fromStringFunction = fromStringFunction;
        this.nullable = nullable;
    }

    @Override
    public void validate(Options.Name name, Object value) throws SQLException {
        if (value == null) {
            if (this.nullable) {
                return;
            }
            throw new SQLException("Option " + String.valueOf((Object)name) + " should not be null", ErrorCode.INVALID_PARAMETER.getErrorCode());
        }
        if (!this.clazz.isInstance(value)) {
            throw new SQLException("Option " + String.valueOf((Object)name) + " should be of type " + String.valueOf(this.clazz) + " but is " + String.valueOf(value.getClass()), ErrorCode.INVALID_PARAMETER.getErrorCode());
        }
    }

    @Override
    @Nullable
    public T fromString(String valueAsString) throws SQLException {
        return this.fromStringFunction.apply(valueAsString);
    }

    @Nonnull
    public static <T> TypeContract<T> of(@Nonnull Class<T> clazz, @Nonnull Function<String, T> fromStringFunction) {
        return new TypeContract<T>(clazz, fromStringFunction, false);
    }

    @Nonnull
    public static TypeContract<Boolean> booleanType() {
        return BOOLEAN_TYPE;
    }

    @Nonnull
    public static TypeContract<String> stringType() {
        return STRING_TYPE;
    }

    @Nonnull
    public static TypeContract<String> nullableStringType() {
        return NULLABLE_STRING_TYPE;
    }

    @Nonnull
    public static TypeContract<Integer> intType() {
        return INTEGER_TYPE;
    }

    @Nonnull
    public static TypeContract<Long> longType() {
        return LONG_TYPE;
    }
}

