/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalArrayBuilder;
import com.apple.foundationdb.relational.api.RelationalArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.jdbc.RelationalResultSetFacade;
import com.apple.foundationdb.relational.jdbc.RelationalStructFacade;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSetMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Array;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Column;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumn;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Struct;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Type;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.PositionalIndex;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RelationalArrayFacade
implements RelationalArray {
    private final ColumnMetadata delegateMetadata;
    private final Supplier<DataType.ArrayType> type;
    private final Array delegate;

    RelationalArrayFacade(@Nonnull ColumnMetadata delegateMetadata, Array array) {
        this.delegateMetadata = delegateMetadata;
        this.type = Suppliers.memoize(this::computeType);
        this.delegate = array;
    }

    @Nullable
    private DataType.ArrayType computeType() {
        return this.delegateMetadata.getType() == Type.UNKNOWN ? null : DataType.ArrayType.from(RelationalStructFacade.RelationalStructFacadeMetaData.getDataType(this.delegateMetadata.getType(), this.delegateMetadata, this.delegateMetadata.getNullable()));
    }

    Array getDelegate() {
        return this.delegate;
    }

    ColumnMetadata getDelegateMetadata() {
        return this.delegateMetadata;
    }

    @Override
    public ArrayMetaData getMetaData() throws SQLException {
        if (this.type.get() != null) {
            return RelationalArrayMetaData.of(this.type.get());
        }
        throw new SQLFeatureNotSupportedException("get Metadata not supported in JDBC Relational Arrays");
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return SqlTypeNamesSupport.getSqlTypeName(this.getBaseType());
    }

    @Override
    public int getBaseType() {
        return 2002;
    }

    @Override
    public Object getArray(long oneBasedIndex, int askedForCount) throws SQLException {
        int index = PositionalIndex.toProtobuf(Math.toIntExact(oneBasedIndex));
        int count = RelationalArrayFacade.getCount(askedForCount, this.delegate.getElementCount(), index);
        Object[] array = new Object[count];
        int j = 0;
        int componentType = this.delegateMetadata.getJavaSqlTypesCode();
        for (int i = index; i < count; ++i) {
            if (componentType == 2002) {
                array[j++] = new RelationalStructFacade(this.delegateMetadata.getStructMetadata(), this.delegate.getElement(i).getStruct());
                continue;
            }
            Assert.failUnchecked(ErrorCode.UNKNOWN_TYPE, "Type not supported: " + SqlTypeNamesSupport.getSqlTypeName(componentType));
        }
        return array;
    }

    private static int getCount(int askedForCount, int elementCount, int zeroBasedOffset) {
        return Math.min(askedForCount, elementCount - zeroBasedOffset);
    }

    @Override
    public RelationalResultSet getResultSet(long oneBasedIndex, int askedForCount) throws SQLException {
        int index = PositionalIndex.toProtobuf(Math.toIntExact(oneBasedIndex));
        int count = RelationalArrayFacade.getCount(askedForCount, this.delegate.getElementCount(), index);
        ResultSet.Builder resultSetBuilder = ResultSet.newBuilder();
        Type componentType = this.delegateMetadata.getType();
        int componentSqlType = this.delegateMetadata.getJavaSqlTypesCode();
        ColumnMetadata.Builder componentColumnBuilder = ColumnMetadata.newBuilder().setName("VALUE").setType(componentType).setJavaSqlTypesCode(componentSqlType);
        if (componentSqlType == 2003) {
            componentColumnBuilder.setArrayMetadata(this.delegateMetadata.getArrayMetadata());
        } else if (componentSqlType == 2002) {
            componentColumnBuilder.setStructMetadata(this.delegateMetadata.getStructMetadata());
        }
        resultSetBuilder.setMetadata(ResultSetMetadata.newBuilder().setColumnMetadata(ListColumnMetadata.newBuilder().addColumnMetadata(ColumnMetadata.newBuilder().setName("INDEX").setType(Type.INTEGER).setJavaSqlTypesCode(4).build()).addColumnMetadata(componentColumnBuilder.build()).build()).build());
        for (int i = index; i < count; ++i) {
            ListColumn.Builder listColumnBuilder = ListColumn.newBuilder();
            listColumnBuilder.addColumn(Column.newBuilder().setInteger(i + 1).build());
            Column.Builder valueColumnBuilder = Column.newBuilder();
            if (componentSqlType == 2002) {
                valueColumnBuilder.setStruct(this.delegate.getElement(i).getStruct());
            } else if (componentSqlType == 4) {
                valueColumnBuilder.setInteger(this.delegate.getElement(i).getInteger());
            } else {
                Assert.failUnchecked(ErrorCode.UNKNOWN_TYPE, "Type not supported: " + SqlTypeNamesSupport.getSqlTypeName(componentSqlType));
            }
            resultSetBuilder.addRow(Struct.newBuilder().setColumns(listColumnBuilder.addColumn(valueColumnBuilder.build())).build());
        }
        return new RelationalResultSetFacade(resultSetBuilder.build());
    }

    static RelationalArrayBuilder newBuilder() {
        return new RelationalArrayFacadeBuilder();
    }

    static class RelationalArrayFacadeBuilder
    implements RelationalArrayBuilder {
        private final Array.Builder builder = Array.newBuilder();
        private ColumnMetadata metadata;

        RelationalArrayFacadeBuilder() {
        }

        @Override
        public RelationalArray build() {
            return new RelationalArrayFacade(this.metadata, this.builder.build());
        }

        @Override
        public RelationalArrayBuilder addAll(Object ... value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addBytes(@Nonnull byte[] value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addString(@Nonnull String value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addLong(@Nonnull long value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addUuid(@Nonnull UUID value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addObject(@Nonnull Object value) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public RelationalArrayBuilder addStruct(RelationalStruct struct) throws SQLException {
            RelationalStructFacade structFacade = struct.unwrap(RelationalStructFacade.class);
            this.initOrCheckMetadata(structFacade.getDelegateMetadata());
            this.builder.addElement(Column.newBuilder().setStruct(structFacade.getDelegate()));
            return this;
        }

        private void initOrCheckMetadata(ListColumnMetadata innerMetadata) {
            if (this.metadata == null) {
                ColumnMetadata.Builder builder = ColumnMetadata.newBuilder().setName("ARRAY").setJavaSqlTypesCode(2002).setType(Type.STRUCT);
                builder.setStructMetadata(innerMetadata);
                this.metadata = builder.build();
            } else {
                Assert.thatUnchecked(this.metadata.getJavaSqlTypesCode() == 2002, ErrorCode.DATATYPE_MISMATCH, "dataType mismatch!");
            }
        }
    }
}

