/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalResultSetMetaData;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.StructResultSetMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.jdbc.RelationalArrayFacade;
import com.apple.foundationdb.relational.jdbc.RelationalResultSetMetaDataFacade;
import com.apple.foundationdb.relational.jdbc.RelationalRpcContinuation;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Column;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ColumnMetadata;
import com.apple.foundationdb.relational.util.ExcludeFromJacocoGeneratedReport;
import com.apple.foundationdb.relational.util.PositionalIndex;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class RelationalResultSetFacade
implements RelationalResultSet {
    private final Supplier<DataType.StructType> type;
    private final ResultSet delegate;
    private final int rows;
    private int rowIndex = -1;
    private volatile boolean closed;
    private boolean wasNull = true;
    private static final int NUMERIC_VALUE_WHEN_NULL = -1;
    static final RelationalResultSet EMPTY = new RelationalResultSetFacade(ResultSet.newBuilder().build());

    RelationalResultSetFacade(ResultSet delegate) {
        this.delegate = delegate;
        this.type = Suppliers.memoize(() -> TypeConversion.getStructDataType(delegate.getMetadata().getColumnMetadata().getColumnMetadataList(), false));
        this.rows = delegate.getRowCount();
    }

    @Override
    public boolean next() throws SQLException {
        return ++this.rowIndex < this.rows;
    }

    public boolean hasNext() {
        return this.rowIndex < this.rows - 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private <R> R get(int oneBasedIndex, Function<Column, R> s2) {
        int index = PositionalIndex.toProtobuf(oneBasedIndex);
        Column column = this.delegate.getRow(this.rowIndex).getColumns().getColumn(index);
        return s2.apply(column);
    }

    @Override
    public String getString(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasString()) {
                this.wasNull = false;
                return column.getString();
            }
            this.wasNull = true;
            return null;
        });
    }

    @Override
    public boolean getBoolean(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasBoolean()) {
                this.wasNull = false;
                return column.getBoolean();
            }
            this.wasNull = true;
            return false;
        });
    }

    @Override
    public int getInt(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasInteger()) {
                this.wasNull = false;
                return column.getInteger();
            }
            this.wasNull = true;
            return -1;
        });
    }

    @Override
    public long getLong(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasLong()) {
                this.wasNull = false;
                return column.getLong();
            }
            this.wasNull = true;
            return -1L;
        });
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public float getFloat(int oneBasedColumn) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not implemented in the relational layer", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public double getDouble(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasDouble()) {
                this.wasNull = false;
                return column.getDouble();
            }
            this.wasNull = true;
            return -1.0;
        });
    }

    @Override
    public byte[] getBytes(int oneBasedColumn) throws SQLException {
        return this.get(oneBasedColumn, column -> {
            if (column.hasBinary()) {
                this.wasNull = false;
                return column.getBinary().toByteArray();
            }
            this.wasNull = true;
            return null;
        });
    }

    private static int columnLabelToColumnOneBasedIndex(List<ColumnMetadata> metadatas, String columnLabel) throws SQLException {
        int index = 0;
        for (ColumnMetadata metadata : metadatas) {
            if (metadata.getName().equalsIgnoreCase(columnLabel)) {
                return index + 1;
            }
            ++index;
        }
        throw new SQLException("Unknown " + columnLabel + " in " + String.valueOf(metadatas.stream().map(n -> n.getName()).collect(Collectors.toList())));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(RelationalResultSetFacade.columnLabelToColumnOneBasedIndex(this.delegate.getMetadata().getColumnMetadata().getColumnMetadataList(), columnLabel));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public boolean getBoolean(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public byte getByte(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public int getInt(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public long getLong(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public float getFloat(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public double getDouble(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public RelationalResultSetMetaData getMetaData() throws SQLException {
        return this.type.get() != null ? new StructResultSetMetaData(RelationalStructMetaData.of(this.type.get())) : new RelationalResultSetMetaDataFacade(this.delegate.getMetadata());
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP"})
    public Continuation getContinuation() throws SQLException {
        if (this.hasNext()) {
            throw new SQLException("Continuation can only be returned for the last row");
        }
        return new RelationalRpcContinuation(this.delegate.getContinuation());
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public RelationalStruct getStruct(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented getStruct");
    }

    @Override
    public RelationalStruct getStruct(int oneBasedColumn) throws SQLException {
        RelationalStruct s2 = TypeConversion.getStruct(this.delegate, this.rowIndex, oneBasedColumn);
        this.wasNull = s2 == null;
        return s2;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public UUID getUUID(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented getUUID");
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public UUID getUUID(int oneBasedColumn) throws SQLException {
        UUID s2 = TypeConversion.getUUID(this.delegate, this.rowIndex, oneBasedColumn);
        this.wasNull = s2 == null;
        return s2;
    }

    @Override
    public Object getObject(int oneBasedColumn) throws SQLException {
        Object o;
        int type = this.getMetaData().getColumnType(oneBasedColumn);
        switch (type) {
            case 12: {
                o = this.getString(oneBasedColumn);
                break;
            }
            case 4: {
                o = this.getInt(oneBasedColumn);
                break;
            }
            case -5: {
                o = this.getLong(oneBasedColumn);
                break;
            }
            case 2002: {
                o = this.getStruct(oneBasedColumn);
                break;
            }
            case 2003: {
                o = this.getArray(oneBasedColumn);
                break;
            }
            case 8: {
                o = this.getDouble(oneBasedColumn);
                break;
            }
            case 16: {
                o = this.getBoolean(oneBasedColumn);
                break;
            }
            case -2: {
                o = this.getBytes(oneBasedColumn);
                break;
            }
            case 1111: {
                int index = PositionalIndex.toProtobuf(oneBasedColumn);
                Column column = this.delegate.getRow(this.rowIndex).getColumns().getColumn(index);
                if (column.hasUuid()) {
                    o = this.getUUID(oneBasedColumn);
                    break;
                }
                o = this.getString(oneBasedColumn);
                break;
            }
            default: {
                throw new SQLException("Unsupported type " + type);
            }
        }
        if (this.wasNull()) {
            return null;
        }
        return o;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(RelationalStruct.getOneBasedPosition(columnLabel, this));
    }

    @Override
    public RelationalArray getArray(int oneBasedColumn) throws SQLException {
        int index = PositionalIndex.toProtobuf(oneBasedColumn);
        ColumnMetadata columnMetadata = this.delegate.getMetadata().getColumnMetadata().getColumnMetadata(index);
        Column column = this.delegate.getRow(this.rowIndex).getColumns().getColumn(index);
        RelationalArrayFacade array = column == null || !column.hasArray() ? null : new RelationalArrayFacade(columnMetadata.getArrayMetadata(), column.getArray());
        this.wasNull = array == null;
        return array;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public RelationalArray getArray(String columnLabel) throws SQLException {
        throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

