/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalResultSetMetaData;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.jdbc.RelationalStructFacade;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSetMetadata;
import com.apple.foundationdb.relational.util.ExcludeFromJacocoGeneratedReport;
import com.apple.foundationdb.relational.util.PositionalIndex;
import java.sql.JDBCType;
import java.sql.SQLException;
import javax.annotation.Nonnull;

class RelationalResultSetMetaDataFacade
implements RelationalResultSetMetaData {
    private final ResultSetMetadata delegate;

    RelationalResultSetMetaDataFacade(ResultSetMetadata delegate) {
        this.delegate = delegate;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public ArrayMetaData getArrayMetaData(int oneBasedColumn) throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    @Nonnull
    public DataType.StructType getRelationalDataType() throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public StructMetaData getStructMetaData(int oneBasedColumn) throws SQLException {
        return new RelationalStructFacade.RelationalStructFacadeMetaData(this.delegate.getColumnMetadata().getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getStructMetadata());
    }

    @Override
    public String getTypeName() throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.delegate.getColumnMetadata().getColumnMetadataCount();
    }

    @Override
    public String getColumnName(int oneBasedColumn) throws SQLException {
        return this.delegate.getColumnMetadata().getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getName();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public int getColumnType(int oneBasedColumn) throws SQLException {
        return this.delegate.getColumnMetadata().getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getJavaSqlTypesCode();
    }

    @Override
    public String getColumnTypeName(int oneBasedColumn) throws SQLException {
        int code = this.getColumnType(oneBasedColumn);
        return JDBCType.valueOf(code).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || iface.isAssignableFrom(StructMetaData.class);
    }
}

