/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.v1.RpcContinuation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelationalRpcContinuation
implements Continuation {
    public static final int CURRENT_VERSION = 1;
    @Nonnull
    private final RpcContinuation proto;

    public RelationalRpcContinuation(@Nonnull RpcContinuation proto) {
        this.proto = proto;
    }

    @Override
    public byte[] serialize() {
        return this.proto.getInternalState().toByteArray();
    }

    @Override
    @Nullable
    public byte[] getExecutionState() {
        if (this.proto.hasInternalState()) {
            return this.proto.getInternalState().toByteArray();
        }
        return null;
    }

    @Override
    public Continuation.Reason getReason() {
        if (this.proto.hasReason()) {
            return TypeConversion.toReason(this.proto.getReason());
        }
        return null;
    }

    @Override
    public boolean atBeginning() {
        return this.proto.getAtBeginning();
    }

    @Override
    public boolean atEnd() {
        return this.proto.getAtEnd();
    }

    @Nonnull
    public RpcContinuation getProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationalRpcContinuation)) {
            return false;
        }
        RelationalRpcContinuation that = (RelationalRpcContinuation)o;
        return Objects.equals(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hashCode(this.proto);
    }
}

