/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.RelationalStructBuilder;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.jdbc.RelationalArrayFacade;
import com.apple.foundationdb.relational.jdbc.TypeConversion;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Column;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.EnumMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumn;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Struct;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Type;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Uuid;
import com.apple.foundationdb.relational.util.PositionalIndex;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.protobuf.ByteString;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RelationalStructFacade
implements RelationalStruct {
    private final StructMetaData structMetaData;
    private final Supplier<DataType.StructType> type = Suppliers.memoize(() -> TypeConversion.getStructDataType(delegateMetadata.getColumnMetadataList(), false));
    private final ListColumnMetadata delegateMetadata;
    private final Struct delegate;
    private boolean wasNull;

    RelationalStructFacade(ListColumnMetadata delegateMetadata, Struct delegate) {
        this.delegate = delegate;
        this.delegateMetadata = delegateMetadata;
        this.structMetaData = new RelationalStructFacadeMetaData(delegateMetadata);
        this.wasNull = false;
    }

    Struct getDelegate() {
        return this.delegate;
    }

    ListColumnMetadata getDelegateMetadata() {
        return this.delegateMetadata;
    }

    @Override
    public StructMetaData getMetaData() {
        return this.type.get() != null ? RelationalStructMetaData.of(this.type.get()) : this.structMetaData;
    }

    @Override
    public boolean getBoolean(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return false;
        }
        if (!c.hasBoolean()) {
            throw new SQLException("Boolean", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getBoolean();
    }

    @Override
    public boolean getBoolean(String fieldName) throws SQLException {
        return this.getBoolean(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public int getInt(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return 0;
        }
        if (!c.hasInteger()) {
            throw new SQLException("Integer", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getInteger();
    }

    @Override
    public int getInt(String fieldName) throws SQLException {
        return this.getInt(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public long getLong(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return 0L;
        }
        if (!c.hasLong()) {
            throw new SQLException("Long", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getLong();
    }

    @Override
    public long getLong(String fieldName) throws SQLException {
        return this.getLong(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public float getFloat(int oneBasedColumn) throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public float getFloat(String fieldName) throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public double getDouble(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return 0.0;
        }
        if (!c.hasDouble()) {
            throw new SQLException("Double", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getDouble();
    }

    @Override
    public double getDouble(String fieldName) throws SQLException {
        return this.getDouble(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public byte[] getBytes(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return null;
        }
        if (!c.hasBinary()) {
            throw new SQLException("Binary", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getBinary().toByteArray();
    }

    @Override
    public byte[] getBytes(String fieldName) throws SQLException {
        return this.getBytes(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public String getString(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return null;
        }
        if (!c.hasString()) {
            throw new SQLException("String", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return c.getString();
    }

    @Override
    public String getString(String fieldName) throws SQLException {
        return this.getString(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public Object getObject(int oneBasedColumn) throws SQLException {
        int type = this.getMetaData().getColumnType(oneBasedColumn);
        Object obj = null;
        switch (type) {
            case 2003: {
                obj = this.getArray(oneBasedColumn);
                break;
            }
            case -5: {
                obj = this.getLong(oneBasedColumn);
                break;
            }
            case -2: {
                obj = this.getBytes(oneBasedColumn);
                break;
            }
            case 12: {
                obj = this.getString(oneBasedColumn);
                break;
            }
            case 2002: {
                obj = this.getStruct(oneBasedColumn);
                break;
            }
            case 8: {
                obj = this.getDouble(oneBasedColumn);
                break;
            }
            case 16: {
                obj = this.getBoolean(oneBasedColumn);
                break;
            }
            case 4: {
                obj = this.getInt(oneBasedColumn);
                break;
            }
            case 1111: {
                obj = this.getUUID(oneBasedColumn);
                break;
            }
            default: {
                throw new SQLException("Unsupported object type: " + type);
            }
        }
        if (this.wasNull()) {
            return null;
        }
        return obj;
    }

    @Override
    public Object getObject(String fieldName) throws SQLException {
        return this.getObject(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public RelationalStruct getStruct(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return null;
        }
        if (!c.hasStruct()) {
            throw new SQLException("Struct", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return new RelationalStructFacade(this.delegateMetadata.getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getStructMetadata(), c.getStruct());
    }

    @Override
    public RelationalStruct getStruct(String fieldName) throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public RelationalArray getArray(int oneBasedColumn) throws SQLException {
        Column c = this.getColumnInternal(oneBasedColumn);
        if (this.wasNull) {
            return null;
        }
        if (!c.hasArray()) {
            throw new SQLException("Array", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return new RelationalArrayFacade(this.delegateMetadata.getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getArrayMetadata(), c.getArray());
    }

    @Override
    public RelationalArray getArray(String fieldName) throws SQLException {
        throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
    }

    @Override
    public UUID getUUID(int oneBasedPosition) throws SQLException {
        Column c = this.getColumnInternal(oneBasedPosition);
        if (this.wasNull) {
            return null;
        }
        if (!c.hasUuid()) {
            throw new SQLException("UUID", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return new UUID(c.getUuid().getMostSignificantBits(), c.getUuid().getLeastSignificantBits());
    }

    @Override
    public UUID getUUID(String fieldName) throws SQLException {
        return this.getUUID(RelationalStruct.getOneBasedPosition(fieldName, this));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private Column getColumnInternal(int oneBasedColumn) {
        Column c = this.delegate.getColumns().getColumn(PositionalIndex.toProtobuf(oneBasedColumn));
        this.wasNull = c.hasNullType() || c.getKindCase().equals(Column.KindCase.KIND_NOT_SET);
        return c;
    }

    static RelationalStructBuilder newBuilder() {
        return new RelationalStructFacadeBuilder();
    }

    static final class RelationalStructFacadeMetaData
    implements StructMetaData {
        private final ListColumnMetadata metadata;
        private final Supplier<DataType.StructType> type;

        RelationalStructFacadeMetaData(ListColumnMetadata metadata) {
            this.metadata = metadata;
            this.type = Suppliers.memoize(this::computeType);
        }

        private DataType.StructType computeType() {
            return RelationalStructFacadeMetaData.getStructDataType(this.metadata.getColumnMetadataList(), false);
        }

        private static DataType.EnumType getEnumDataType(@Nonnull EnumMetadata enumMetadata, boolean nullable) {
            ArrayList<DataType.EnumType.EnumValue> enumValues = new ArrayList<DataType.EnumType.EnumValue>();
            int i = 1;
            for (String value : enumMetadata.getValuesList()) {
                enumValues.add(DataType.EnumType.EnumValue.of(value, i++));
            }
            return DataType.EnumType.from(enumMetadata.getName(), enumValues, nullable);
        }

        private static DataType.StructType getStructDataType(@Nonnull List<ColumnMetadata> columnMetadataList, boolean nullable) {
            ArrayList<DataType.StructType.Field> fields = new ArrayList<DataType.StructType.Field>();
            for (int i = 0; i < columnMetadataList.size(); ++i) {
                ColumnMetadata columnMetadata = columnMetadataList.get(i);
                fields.add(DataType.StructType.Field.from(columnMetadata.getName(), RelationalStructFacadeMetaData.getDataType(columnMetadata.getType(), columnMetadata, columnMetadata.getNullable()), i));
            }
            return DataType.StructType.from("ANONYMOUS_STRUCT", fields, nullable);
        }

        static DataType getDataType(@Nonnull Type type, @Nonnull ColumnMetadata columnMetadata, boolean nullable) {
            switch (type) {
                case LONG: {
                    return nullable ? DataType.Primitives.NULLABLE_LONG.type() : DataType.Primitives.LONG.type();
                }
                case INTEGER: {
                    return nullable ? DataType.Primitives.NULLABLE_INTEGER.type() : DataType.Primitives.INTEGER.type();
                }
                case DOUBLE: {
                    return nullable ? DataType.Primitives.NULLABLE_DOUBLE.type() : DataType.Primitives.DOUBLE.type();
                }
                case FLOAT: {
                    return nullable ? DataType.Primitives.NULLABLE_FLOAT.type() : DataType.Primitives.FLOAT.type();
                }
                case BOOLEAN: {
                    return nullable ? DataType.Primitives.NULLABLE_BOOLEAN.type() : DataType.Primitives.BOOLEAN.type();
                }
                case BYTES: {
                    return nullable ? DataType.Primitives.NULLABLE_BYTES.type() : DataType.Primitives.BYTES.type();
                }
                case UUID: {
                    return nullable ? DataType.Primitives.NULLABLE_UUID.type() : DataType.Primitives.UUID.type();
                }
                case STRING: {
                    return nullable ? DataType.Primitives.NULLABLE_STRING.type() : DataType.Primitives.STRING.type();
                }
                case VERSION: {
                    return nullable ? DataType.Primitives.NULLABLE_VERSION.type() : DataType.Primitives.VERSION.type();
                }
                case STRUCT: {
                    return RelationalStructFacadeMetaData.getStructDataType(columnMetadata.getStructMetadata().getColumnMetadataList(), nullable);
                }
                case ENUM: {
                    return RelationalStructFacadeMetaData.getEnumDataType(columnMetadata.getEnumMetadata(), nullable);
                }
                case ARRAY: {
                    ColumnMetadata arrayMetadata = columnMetadata.getArrayMetadata();
                    return DataType.ArrayType.from(RelationalStructFacadeMetaData.getDataType(arrayMetadata.getType(), arrayMetadata, arrayMetadata.getNullable()), nullable);
                }
            }
            throw new RelationalException("Not implemeneted: " + type.name(), ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.metadata.getColumnMetadataCount();
        }

        @Override
        public int isNullable(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public String getTypeName() throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public String getColumnLabel(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public String getColumnName(int oneBasedColumn) throws SQLException {
            return this.metadata.getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getName();
        }

        @Override
        public String getSchemaName(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public String getTableName(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public String getCatalogName(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public int getColumnType(int oneBasedColumn) throws SQLException {
            return this.metadata.getColumnMetadata(PositionalIndex.toProtobuf(oneBasedColumn)).getJavaSqlTypesCode();
        }

        @Override
        public String getColumnTypeName(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public StructMetaData getStructMetaData(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public ArrayMetaData getArrayMetaData(int oneBasedColumn) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public int getLeadingPhantomColumnCount() {
            return -1000;
        }

        @Override
        @Nonnull
        public DataType.StructType getRelationalDataType() {
            return this.type.get();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new SQLException("Not implemented", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
    }

    @VisibleForTesting
    static final class RelationalStructFacadeBuilder
    implements RelationalStructBuilder {
        private final ListColumn.Builder listColumnBuilder = ListColumn.newBuilder();
        private final List<String> fieldOrder = new ArrayList<String>();
        private final Map<String, ColumnMetadata> metadata = new HashMap<String, ColumnMetadata>();

        RelationalStructFacadeBuilder() {
        }

        @VisibleForTesting
        int addMetadata(ColumnMetadata columnMetadata) {
            int offset = this.getZeroBasedOffset(columnMetadata.getName());
            if (offset == -1) {
                offset = this.metadata.size();
                this.fieldOrder.add(columnMetadata.getName());
            }
            this.metadata.put(columnMetadata.getName(), columnMetadata);
            return offset;
        }

        @VisibleForTesting
        int getZeroBasedOffset(String fieldName) {
            int offset = -1;
            if (this.metadata.containsKey(fieldName)) {
                for (int i = 0; i < this.fieldOrder.size(); ++i) {
                    if (!this.fieldOrder.get(i).equals(fieldName)) continue;
                    return offset;
                }
            }
            return offset;
        }

        @VisibleForTesting
        int getZeroBasedOffsetOrThrow(String fieldName) throws SQLException {
            int offset = this.getZeroBasedOffset(fieldName);
            if (offset == -1) {
                throw new SQLException("Unknown " + fieldName);
            }
            return offset;
        }

        @Override
        public RelationalStructBuilder addBoolean(String fieldName, boolean b) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(16).setType(Type.BOOLEAN).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setBoolean(b).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addLong(String fieldName, long l) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(-5).setType(Type.LONG).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setLong(l).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addFloat(String fieldName, float f) throws SQLException {
            throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
        }

        @Override
        public RelationalStructBuilder addDouble(String fieldName, double d) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(8).setType(Type.DOUBLE).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setDouble(d).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addBytes(String fieldName, byte[] bytes) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(-2).setType(Type.BYTES).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setBinary(ByteString.copyFrom(bytes)).build());
            return this;
        }

        @Override
        @SpotBugsSuppressWarnings(value={"NP"})
        public RelationalStructBuilder addString(String fieldName, @Nullable String s2) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(12).setType(Type.STRING).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setString(s2).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addUuid(String fieldName, @Nullable UUID uuid) {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(1111).setType(Type.UUID).build());
            if (uuid == null) {
                this.listColumnBuilder.addColumn(offset, Column.newBuilder().build());
            } else {
                Uuid uuidColumn = Uuid.newBuilder().setMostSignificantBits(uuid.getMostSignificantBits()).setLeastSignificantBits(uuid.getLeastSignificantBits()).build();
                this.listColumnBuilder.addColumn(offset, Column.newBuilder().setUuid(uuidColumn).build());
            }
            return this;
        }

        @Override
        public RelationalStructBuilder addObject(String fieldName, @Nullable Object obj) throws SQLException {
            throw new SQLException("Not implemented " + Thread.currentThread().getStackTrace()[1].getMethodName());
        }

        @Override
        public RelationalStructBuilder addStruct(String fieldName, @Nonnull RelationalStruct struct) throws SQLException {
            RelationalStructFacade relationalStructFacade = struct.unwrap(RelationalStructFacade.class);
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(2002).setType(Type.STRUCT).setStructMetadata(relationalStructFacade.delegateMetadata).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setStruct(relationalStructFacade.delegate).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addArray(String fieldName, @Nonnull RelationalArray array) throws SQLException {
            RelationalArrayFacade relationalArrayFacade = array.unwrap(RelationalArrayFacade.class);
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setJavaSqlTypesCode(2003).setType(Type.ARRAY).setArrayMetadata(relationalArrayFacade.getDelegateMetadata()).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setArray(relationalArrayFacade.getDelegate()).build());
            return this;
        }

        @Override
        public RelationalStructBuilder addInt(String fieldName, int i) throws SQLException {
            int offset = this.addMetadata(ColumnMetadata.newBuilder().setName(fieldName).setType(Type.INTEGER).build());
            this.listColumnBuilder.addColumn(offset, Column.newBuilder().setInteger(i).build());
            return this;
        }

        @Override
        public RelationalStruct build() {
            ListColumnMetadata.Builder columnListMetadataBuilder = ListColumnMetadata.newBuilder();
            this.fieldOrder.forEach(s2 -> columnListMetadataBuilder.addColumnMetadata(this.metadata.get(s2)));
            Struct struct = Struct.newBuilder().setColumns(this.listColumnBuilder.build()).build();
            return new RelationalStructFacade(columnListMetadataBuilder.build(), struct);
        }
    }
}

