/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.jdbc.RelationalStructFacade;
import com.apple.foundationdb.relational.jdbc.grpc.v1.KeySet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.KeySetValue;
import com.apple.foundationdb.relational.jdbc.grpc.v1.Options;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSet;
import com.apple.foundationdb.relational.jdbc.grpc.v1.ResultSetMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.RpcContinuation;
import com.apple.foundationdb.relational.jdbc.grpc.v1.RpcContinuationReason;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Array;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Column;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.EnumMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumn;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.ListColumnMetadata;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Struct;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Type;
import com.apple.foundationdb.relational.jdbc.grpc.v1.column.Uuid;
import com.apple.foundationdb.relational.util.PositionalIndex;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TypeConversion {
    static RelationalStruct getStruct(ResultSet resultSet, int rowIndex, int oneBasedColumn) throws SQLException {
        int index = PositionalIndex.toProtobuf(oneBasedColumn);
        ListColumnMetadata metadata = resultSet.getMetadata().getColumnMetadata().getColumnMetadata(index).getStructMetadata();
        Column column = resultSet.getRow(rowIndex).getColumns().getColumn(index);
        return column.hasStruct() ? new RelationalStructFacade(metadata, column.getStruct()) : null;
    }

    static UUID getUUID(ResultSet resultSet, int rowIndex, int oneBasedColumn) throws SQLException {
        int index = PositionalIndex.toProtobuf(oneBasedColumn);
        Column column = resultSet.getRow(rowIndex).getColumns().getColumn(index);
        return column.hasUuid() ? new UUID(column.getUuid().getMostSignificantBits(), column.getUuid().getLeastSignificantBits()) : null;
    }

    static ResultSet toResultSetProtobuf(List<RelationalStruct> structs) throws SQLException {
        ResultSet.Builder resultSetBuilder = ResultSet.newBuilder();
        for (RelationalStruct struct : structs) {
            RelationalStructFacade relationalStruct = struct.unwrap(RelationalStructFacade.class);
            if (!resultSetBuilder.hasMetadata()) {
                ResultSetMetadata.Builder resultSetMetadataBuilder = ResultSetMetadata.newBuilder();
                resultSetBuilder.setMetadata(resultSetMetadataBuilder.setColumnMetadata(relationalStruct.getDelegateMetadata()).build());
            }
            resultSetBuilder.addRow(relationalStruct.getDelegate());
        }
        return resultSetBuilder.build();
    }

    public static List<RelationalStruct> fromResultSetProtobuf(ResultSet data) {
        int rowCount = data.getRowCount();
        ArrayList<RelationalStruct> structs = new ArrayList<RelationalStruct>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            structs.add(new RelationalStructFacade(data.getMetadata().getColumnMetadata(), data.getRow(i++)));
        }
        return structs;
    }

    static KeySet toProtobuf(com.apple.foundationdb.relational.api.KeySet keySet) {
        KeySet.Builder keySetBuilder = KeySet.newBuilder();
        for (Map.Entry<String, Object> entry : keySet.toMap().entrySet()) {
            KeySetValue keySetValue;
            if (entry.getValue() instanceof String) {
                keySetValue = KeySetValue.newBuilder().setStringValue((String)entry.getValue()).build();
            } else if (entry.getValue() instanceof byte[]) {
                keySetValue = KeySetValue.newBuilder().setBytesValue(ByteString.copyFrom((byte[])entry.getValue())).build();
            } else if (entry.getValue() instanceof Long) {
                keySetValue = KeySetValue.newBuilder().setLongValue((Long)entry.getValue()).build();
            } else {
                throw new UnsupportedOperationException("Unsupported type " + String.valueOf(entry.getValue()));
            }
            keySetBuilder.putFields(entry.getKey(), keySetValue);
        }
        return keySetBuilder.build();
    }

    public static com.apple.foundationdb.relational.api.KeySet fromProtobuf(KeySet protobufKeySet) throws SQLException {
        com.apple.foundationdb.relational.api.KeySet keySet = new com.apple.foundationdb.relational.api.KeySet();
        for (Map.Entry<String, KeySetValue> entry : protobufKeySet.getFieldsMap().entrySet()) {
            keySet.setKeyColumn(entry.getKey(), entry.getValue().hasBytesValue() ? entry.getValue().getBytesValue() : (entry.getValue().hasLongValue() ? Long.valueOf(entry.getValue().getLongValue()) : (entry.getValue().hasStringValue() ? entry.getValue().getStringValue() : null)));
        }
        return keySet;
    }

    private static ColumnMetadata toColumnMetadata(StructMetaData metadata, int oneBasedIndex, int fieldIndex) throws SQLException {
        DataType type = metadata.getRelationalDataType().getFields().get(fieldIndex).getType();
        Type protobufType = TypeConversion.toProtobufType(type);
        ColumnMetadata.Builder columnMetadataBuilder = ColumnMetadata.newBuilder().setName(metadata.getColumnName(oneBasedIndex)).setJavaSqlTypesCode(metadata.getColumnType(oneBasedIndex)).setNullable(metadata.isNullable(oneBasedIndex) == 1).setType(protobufType);
        switch (protobufType) {
            case STRUCT: {
                ListColumnMetadata listColumnMetadata = TypeConversion.toListColumnMetadataProtobuf(metadata.getStructMetaData(oneBasedIndex));
                columnMetadataBuilder.setStructMetadata(listColumnMetadata);
                break;
            }
            case ARRAY: {
                ColumnMetadata columnMetadata = TypeConversion.toColumnMetadata(metadata.getArrayMetaData(oneBasedIndex));
                columnMetadataBuilder.setArrayMetadata(columnMetadata);
                break;
            }
            case ENUM: {
                EnumMetadata enumMetadata = TypeConversion.toEnumMetadata((DataType.EnumType)type);
                columnMetadataBuilder.setEnumMetadata(enumMetadata);
                break;
            }
        }
        return columnMetadataBuilder.build();
    }

    private static EnumMetadata toEnumMetadata(@Nonnull DataType.EnumType enumType) {
        EnumMetadata.Builder builder = EnumMetadata.newBuilder().setName(enumType.getName());
        enumType.getValues().forEach(v -> builder.addValues(v.getName()));
        return builder.build();
    }

    private static Type toProtobufType(@Nonnull DataType type) {
        switch (type.getCode()) {
            case LONG: {
                return Type.LONG;
            }
            case INTEGER: {
                return Type.INTEGER;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case BYTES: {
                return Type.BYTES;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case STRING: {
                return Type.STRING;
            }
            case STRUCT: {
                return Type.STRUCT;
            }
            case ARRAY: {
                return Type.ARRAY;
            }
            case VERSION: {
                return Type.VERSION;
            }
            case ENUM: {
                return Type.ENUM;
            }
            case UUID: {
                return Type.UUID;
            }
        }
        throw new RelationalException("not supported in toProtobuf: " + String.valueOf(type), ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
    }

    private static ColumnMetadata toColumnMetadata(@Nonnull ArrayMetaData metadata) throws SQLException {
        ColumnMetadata.Builder columnMetadataBuilder = ColumnMetadata.newBuilder().setName(metadata.getElementName()).setJavaSqlTypesCode(metadata.getElementType()).setType(TypeConversion.toProtobufType(metadata.asRelationalType().getElementType())).setNullable(metadata.isElementNullable() == 1);
        switch (metadata.getElementType()) {
            case 2002: {
                ListColumnMetadata listColumnMetadata = TypeConversion.toListColumnMetadataProtobuf(metadata.getElementStructMetaData());
                columnMetadataBuilder.setStructMetadata(listColumnMetadata);
                break;
            }
            case 2003: {
                ColumnMetadata columnMetadata = TypeConversion.toColumnMetadata(metadata.getElementArrayMetaData());
                columnMetadataBuilder.setArrayMetadata(columnMetadata);
                break;
            }
        }
        return columnMetadataBuilder.build();
    }

    private static ListColumnMetadata toListColumnMetadataProtobuf(@Nonnull StructMetaData metadata) throws SQLException {
        ListColumnMetadata.Builder listColumnMetadataBuilder = ListColumnMetadata.newBuilder();
        for (int oneBasedIndex = 1; oneBasedIndex <= metadata.getColumnCount(); ++oneBasedIndex) {
            ColumnMetadata columnMetadata = TypeConversion.toColumnMetadata(metadata, oneBasedIndex, oneBasedIndex - 1 + metadata.getLeadingPhantomColumnCount());
            listColumnMetadataBuilder.addColumnMetadata(columnMetadata);
        }
        return listColumnMetadataBuilder.build();
    }

    private static ResultSetMetadata toResultSetMetaData(RelationalResultSet resultSet, int columnCount) throws SQLException {
        ListColumnMetadata.Builder listColumnMetadataBuilder = ListColumnMetadata.newBuilder();
        for (int oneBasedIndex = 1; oneBasedIndex <= columnCount; ++oneBasedIndex) {
            listColumnMetadataBuilder.addColumnMetadata(TypeConversion.toColumnMetadata(resultSet.getMetaData(), oneBasedIndex, oneBasedIndex - 1 + resultSet.getMetaData().getLeadingPhantomColumnCount()));
        }
        return ResultSetMetadata.newBuilder().setColumnMetadata(TypeConversion.toListColumnMetadataProtobuf(resultSet.getMetaData())).build();
    }

    private static Array toArray(RelationalArray relationalArray) throws SQLException {
        Array.Builder arrayBuilder = Array.newBuilder();
        if (relationalArray != null) {
            RelationalResultSet relationalResultSet = relationalArray.getResultSet();
            while (relationalResultSet.next()) {
                Object value = relationalResultSet.getObject(2);
                arrayBuilder.addElement(TypeConversion.toColumn(relationalResultSet.getMetaData().getRelationalDataType().getFields().get(1), value, relationalResultSet.wasNull()));
            }
        }
        return arrayBuilder.build();
    }

    private static Struct toStruct(RelationalStruct relationalStruct) throws SQLException {
        ListColumn.Builder listColumnBuilder = ListColumn.newBuilder();
        int leadingPhantomCount = relationalStruct.getMetaData().getLeadingPhantomColumnCount();
        List<DataType.StructType.Field> fields = relationalStruct.getMetaData().getRelationalDataType().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (i < leadingPhantomCount) continue;
            Object value = relationalStruct.getObject(i + 1);
            listColumnBuilder.addColumn(TypeConversion.toColumn(fields.get(i), value, relationalStruct.wasNull()));
        }
        return Struct.newBuilder().setColumns(listColumnBuilder.build()).build();
    }

    public static Object fromColumn(int columnType, Column column) throws SQLException {
        switch (columnType) {
            case 2003: {
                TypeConversion.checkColumnType(columnType, column.hasArray());
                return TypeConversion.fromArray(column.getArray());
            }
            case -5: {
                TypeConversion.checkColumnType(columnType, column.hasLong());
                return column.getLong();
            }
            case 4: {
                TypeConversion.checkColumnType(columnType, column.hasInteger());
                return column.getInteger();
            }
            case 16: {
                TypeConversion.checkColumnType(columnType, column.hasBoolean());
                return column.getBoolean();
            }
            case 12: {
                TypeConversion.checkColumnType(columnType, column.hasString());
                return column.getString();
            }
            case -2: {
                TypeConversion.checkColumnType(columnType, column.hasBinary());
                return column.getBinary().toByteArray();
            }
            case 8: {
                TypeConversion.checkColumnType(columnType, column.hasDouble());
                return column.getDouble();
            }
        }
        throw new SQLException("java.sql.Type=" + columnType + " not supported", ErrorCode.ARRAY_ELEMENT_ERROR.getErrorCode());
    }

    private static void checkColumnType(int expectedColumnType, boolean columnHasType) throws SQLException {
        if (!columnHasType) {
            throw new SQLException("Column has wrong type (expected " + expectedColumnType + ")", ErrorCode.WRONG_OBJECT_TYPE.getErrorCode());
        }
    }

    public static Object[] fromArray(Array array) throws SQLException {
        Object[] result = new Object[array.getElementCount()];
        List<Column> elements = array.getElementList();
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = TypeConversion.fromColumn(array.getElementType(), elements.get(i));
        }
        return result;
    }

    public static Array toArray(@Nonnull java.sql.Array array) throws SQLException {
        Array.Builder builder = Array.newBuilder();
        builder.setElementType(array.getBaseType());
        for (Object o : (Object[])array.getArray()) {
            builder.addElement(TypeConversion.toColumn(array.getBaseType(), o));
        }
        return builder.build();
    }

    public static Column toColumn(int columnType, @Nonnull Object obj) throws SQLException {
        if (columnType != DataType.getDataTypeFromObject(obj).getJdbcSqlCode()) {
            throw new SQLException("Column element type does not match object type: " + columnType + " / " + obj.getClass().getSimpleName(), ErrorCode.WRONG_OBJECT_TYPE.getErrorCode());
        }
        Column.Builder builder = Column.newBuilder();
        switch (columnType) {
            case -5: {
                builder = builder.setLong((Long)obj);
                break;
            }
            case 4: {
                builder = builder.setInteger((Integer)obj);
                break;
            }
            case 16: {
                builder = builder.setBoolean((Boolean)obj);
                break;
            }
            case 12: {
                builder = builder.setString((String)obj);
                break;
            }
            case -2: {
                builder = builder.setBinary((ByteString)obj);
                break;
            }
            case 8: {
                builder = builder.setDouble((Double)obj);
                break;
            }
            case 2003: {
                builder = builder.setArray(TypeConversion.toArray((java.sql.Array)obj));
                break;
            }
            case 0: {
                builder = builder.setNullType((Integer)obj);
                break;
            }
            default: {
                throw new SQLException("java.sql.Type=" + columnType + " not supported", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
            }
        }
        return builder.build();
    }

    private static Column toColumn(@Nonnull DataType.StructType.Field field, @Nonnull Object value, boolean wasNull) throws SQLException {
        Column column;
        switch (field.getType().getCode()) {
            case STRUCT: {
                column = TypeConversion.toColumn(wasNull ? null : TypeConversion.toStruct((RelationalStruct)value), (P a, Column.Builder b) -> a == null ? b.clearStruct() : b.setStruct((Struct)a));
                break;
            }
            case ARRAY: {
                column = TypeConversion.toColumn(wasNull ? null : TypeConversion.toArray((RelationalArray)value), (P a, Column.Builder b) -> a == null ? b.clearArray() : b.setArray((Array)a));
                break;
            }
            case LONG: {
                column = TypeConversion.toColumn(wasNull ? null : (Long)value, (P a, Column.Builder b) -> a == null ? b.clearLong() : b.setLong((long)a));
                break;
            }
            case INTEGER: {
                column = TypeConversion.toColumn(wasNull ? null : (Integer)value, (P a, Column.Builder b) -> a == null ? b.clearInteger() : b.setInteger((int)a));
                break;
            }
            case BOOLEAN: {
                column = TypeConversion.toColumn(wasNull ? null : (Boolean)value, (P a, Column.Builder b) -> a == null ? b.clearBoolean() : b.setBoolean((boolean)a));
                break;
            }
            case STRING: 
            case ENUM: {
                column = TypeConversion.toColumn(wasNull ? null : (String)value, (P a, Column.Builder b) -> a == null ? b.clearString() : b.setString((String)a));
                break;
            }
            case BYTES: 
            case VERSION: {
                column = TypeConversion.toColumn(wasNull ? null : (byte[])value, (P a, Column.Builder b) -> a == null ? b.clearBinary() : b.setBinary(ByteString.copyFrom(a)));
                break;
            }
            case DOUBLE: {
                column = TypeConversion.toColumn(wasNull ? null : (Double)value, (P a, Column.Builder b) -> a == null ? b.clearDouble() : b.setDouble((double)a));
                break;
            }
            case UUID: {
                column = TypeConversion.toColumn(wasNull ? null : (UUID)value, (P a, Column.Builder b) -> a == null ? b.clearUuid() : b.setUuid(Uuid.newBuilder().setMostSignificantBits(a.getMostSignificantBits()).setLeastSignificantBits(a.getLeastSignificantBits()).build()));
                break;
            }
            default: {
                throw new SQLException("DataType: " + String.valueOf(field.getType()) + " not supported", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
            }
        }
        return column;
    }

    @Nullable
    static DataType.StructType getStructDataType(@Nonnull List<ColumnMetadata> columnMetadataList, boolean nullable) {
        ArrayList<DataType.StructType.Field> structFields = new ArrayList<DataType.StructType.Field>();
        for (int i = 0; i < columnMetadataList.size(); ++i) {
            ColumnMetadata colMetadata = columnMetadataList.get(i);
            if (colMetadata.getType() == Type.UNKNOWN) {
                return null;
            }
            DataType dataType = RelationalStructFacade.RelationalStructFacadeMetaData.getDataType(colMetadata.getType(), colMetadata, colMetadata.getNullable());
            structFields.add(DataType.StructType.Field.from(colMetadata.getName(), dataType, i));
        }
        return DataType.StructType.from("ANONYMOUS_STRUCT", structFields, nullable);
    }

    @VisibleForTesting
    static <P> Column toColumn(P p, BiFunction<P, Column.Builder, Column.Builder> f) {
        return f.apply(p, Column.newBuilder()).build();
    }

    public static ResultSet toProtobuf(RelationalResultSet relationalResultSet) throws SQLException {
        if (relationalResultSet == null) {
            return null;
        }
        ResultSet.Builder resultSetBuilder = ResultSet.newBuilder();
        while (relationalResultSet.next()) {
            if (!resultSetBuilder.hasMetadata()) {
                resultSetBuilder.setMetadata(TypeConversion.toResultSetMetaData(relationalResultSet, relationalResultSet.getMetaData().getColumnCount()));
            }
            resultSetBuilder.addRow(TypeConversion.toStruct(relationalResultSet));
        }
        Continuation existingContinuation = relationalResultSet.getContinuation();
        RpcContinuation rpcContinuation = TypeConversion.toContinuation(existingContinuation);
        resultSetBuilder.setContinuation(rpcContinuation);
        return resultSetBuilder.build();
    }

    private static RpcContinuation toContinuation(@Nonnull Continuation existingContinuation) {
        Continuation.Reason reason;
        RpcContinuation.Builder builder = RpcContinuation.newBuilder().setVersion(1).setAtBeginning(existingContinuation.atBeginning()).setAtEnd(existingContinuation.atEnd());
        byte[] state = existingContinuation.serialize();
        if (state != null) {
            builder.setInternalState(ByteString.copyFrom(state));
        }
        if ((reason = existingContinuation.getReason()) != null) {
            builder.setReason(TypeConversion.toReason(reason));
        }
        return builder.build();
    }

    public static RpcContinuationReason toReason(Continuation.Reason reason) {
        if (reason == null) {
            return null;
        }
        switch (reason) {
            case TRANSACTION_LIMIT_REACHED: {
                return RpcContinuationReason.TRANSACTION_LIMIT_REACHED;
            }
            case QUERY_EXECUTION_LIMIT_REACHED: {
                return RpcContinuationReason.QUERY_EXECUTION_LIMIT_REACHED;
            }
            case CURSOR_AFTER_LAST: {
                return RpcContinuationReason.CURSOR_AFTER_LAST;
            }
        }
        throw new IllegalStateException("Unrecognized continuation reason: " + String.valueOf((Object)reason));
    }

    public static Continuation.Reason toReason(RpcContinuationReason reason) {
        if (reason == null) {
            return null;
        }
        switch (reason) {
            case TRANSACTION_LIMIT_REACHED: {
                return Continuation.Reason.TRANSACTION_LIMIT_REACHED;
            }
            case QUERY_EXECUTION_LIMIT_REACHED: {
                return Continuation.Reason.QUERY_EXECUTION_LIMIT_REACHED;
            }
            case CURSOR_AFTER_LAST: {
                return Continuation.Reason.CURSOR_AFTER_LAST;
            }
        }
        throw new IllegalStateException("Unrecognized continuation reason: " + String.valueOf(reason));
    }

    @VisibleForTesting
    static Options.Builder toProtobuf(@Nonnull com.apple.foundationdb.relational.api.Options options) throws SQLException {
        Options.Builder builder = Options.newBuilder();
        builder.setContinuationsContainCompiledStatements(true);
        block38: for (Map.Entry<Options.Name, ?> entry : options.entries()) {
            block0 : switch (entry.getKey()) {
                case MAX_ROWS: {
                    builder.setMaxRows((Integer)entry.getValue());
                    break;
                }
                case CONTINUATION: {
                    builder.setContinuation(ByteString.copyFrom(((Continuation)entry.getValue()).serialize()));
                    break;
                }
                case INDEX_HINT: {
                    builder.setIndexHint((String)entry.getValue());
                    break;
                }
                case REQUIRED_METADATA_TABLE_VERSION: {
                    builder.setRequiredMetadataTableVersion((Integer)entry.getValue());
                    break;
                }
                case TRANSACTION_TIMEOUT: {
                    builder.setTransactionTimeout((Long)entry.getValue());
                    break;
                }
                case REPLACE_ON_DUPLICATE_PK: {
                    builder.setReplaceOnDuplicatePk((Boolean)entry.getValue());
                    break;
                }
                case PLAN_CACHE_PRIMARY_MAX_ENTRIES: {
                    builder.setPlanCachePrimaryMaxEntries((Integer)entry.getValue());
                    break;
                }
                case PLAN_CACHE_SECONDARY_MAX_ENTRIES: {
                    builder.setPlanCacheSecondaryMaxEntries((Integer)entry.getValue());
                    break;
                }
                case PLAN_CACHE_TERTIARY_MAX_ENTRIES: {
                    builder.setPlanCacheTertiaryMaxEntries((Integer)entry.getValue());
                    break;
                }
                case PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS: {
                    builder.setPlanCachePrimaryTimeToLiveMillis((Long)entry.getValue());
                    break;
                }
                case PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS: {
                    builder.setPlanCacheSecondaryTimeToLiveMillis((Long)entry.getValue());
                    break;
                }
                case PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS: {
                    builder.setPlanCacheTertiaryTimeToLiveMillis((Long)entry.getValue());
                    break;
                }
                case INDEX_FETCH_METHOD: {
                    switch ((Options.IndexFetchMethod)((Object)entry.getValue())) {
                        case SCAN_AND_FETCH: {
                            builder.setIndexFetchMethod(Options.IndexFetchMethod.SCAN_AND_FETCH);
                            break block0;
                        }
                        case USE_REMOTE_FETCH: {
                            builder.setIndexFetchMethod(Options.IndexFetchMethod.USE_REMOTE_FETCH);
                            break block0;
                        }
                        case USE_REMOTE_FETCH_WITH_FALLBACK: {
                            builder.setIndexFetchMethod(Options.IndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK);
                            break block0;
                        }
                    }
                    throw new SQLException("Unknown fetch method");
                }
                case DISABLED_PLANNER_RULES: {
                    for (String rule : (Collection)entry.getValue()) {
                        builder.addDisabledPlannerRules(rule);
                    }
                    continue block38;
                }
                case DISABLE_PLANNER_REWRITING: {
                    builder.setDisablePlannerRewriting((Boolean)entry.getValue());
                    break;
                }
                case LOG_QUERY: {
                    builder.setLogQuery((Boolean)entry.getValue());
                    break;
                }
                case LOG_SLOW_QUERY_THRESHOLD_MICROS: {
                    builder.setLogSlowQueryThresholdMicros((Long)entry.getValue());
                    break;
                }
                case EXECUTION_TIME_LIMIT: {
                    builder.setExecutionTimeLimit((Long)entry.getValue());
                    break;
                }
                case EXECUTION_SCANNED_BYTES_LIMIT: {
                    builder.setExecutionScannedBytesLimit((Long)entry.getValue());
                    break;
                }
                case EXECUTION_SCANNED_ROWS_LIMIT: {
                    builder.setExecutionScannedRowsLimit((Integer)entry.getValue());
                    break;
                }
                case DRY_RUN: {
                    builder.setDryRun((Boolean)entry.getValue());
                    break;
                }
                case CASE_SENSITIVE_IDENTIFIERS: {
                    builder.setCaseSensitiveIdentifiers((Boolean)entry.getValue());
                    break;
                }
                case CURRENT_PLAN_HASH_MODE: {
                    builder.setCurrentPlanHashMode((String)entry.getValue());
                    break;
                }
                case VALID_PLAN_HASH_MODES: {
                    builder.setValidPlanHashModes((String)entry.getValue());
                    break;
                }
                case ASYNC_OPERATIONS_TIMEOUT_MILLIS: {
                    builder.setAsyncOperationsTimeoutMillis((Long)entry.getValue());
                    break;
                }
                case ENCRYPT_WHEN_SERIALIZING: {
                    builder.setEncryptWhenSerializing((Boolean)entry.getValue());
                    break;
                }
                case ENCRYPTION_KEY_STORE: {
                    if (com.apple.foundationdb.relational.api.Options.isNull(entry.getValue())) {
                        builder.clearEncryptionKeyStore();
                        break;
                    }
                    builder.setEncryptionKeyStore((String)entry.getValue());
                    break;
                }
                case ENCRYPTION_KEY_ENTRY: {
                    if (com.apple.foundationdb.relational.api.Options.isNull(entry.getValue())) {
                        builder.clearEncryptionKeyEntry();
                        break;
                    }
                    builder.setEncryptionKeyEntry((String)entry.getValue());
                    break;
                }
                case ENCRYPTION_KEY_ENTRY_LIST: {
                    for (String rule : (List)entry.getValue()) {
                        builder.addEncryptionKeyEntryList(rule);
                    }
                    continue block38;
                }
                case ENCRYPTION_KEY_PASSWORD: {
                    if (com.apple.foundationdb.relational.api.Options.isNull(entry.getValue())) {
                        builder.clearEncryptionKeyPassword();
                        break;
                    }
                    builder.setEncryptionKeyPassword((String)entry.getValue());
                    break;
                }
                case COMPRESS_WHEN_SERIALIZING: {
                    builder.setCompressWhenSerializing((Boolean)entry.getValue());
                    break;
                }
                default: {
                    throw new SQLException("Cannot encode option in protobuf");
                }
            }
        }
        return builder;
    }

    public static com.apple.foundationdb.relational.api.Options fromProtobuf(Options protoOptions) throws SQLException {
        Options.Builder builder = com.apple.foundationdb.relational.api.Options.builder();
        if (protoOptions.hasMaxRows()) {
            builder.withOption(Options.Name.MAX_ROWS, protoOptions.getMaxRows());
        }
        if (protoOptions.hasContinuation()) {
            builder.withOption(Options.Name.CONTINUATION, protoOptions.getContinuation().toByteArray());
        }
        if (protoOptions.hasIndexHint()) {
            builder.withOption(Options.Name.INDEX_HINT, protoOptions.getIndexHint());
        }
        if (protoOptions.hasRequiredMetadataTableVersion()) {
            builder.withOption(Options.Name.REQUIRED_METADATA_TABLE_VERSION, protoOptions.getRequiredMetadataTableVersion());
        }
        if (protoOptions.hasTransactionTimeout()) {
            builder.withOption(Options.Name.TRANSACTION_TIMEOUT, protoOptions.getTransactionTimeout());
        }
        if (protoOptions.hasReplaceOnDuplicatePk()) {
            builder.withOption(Options.Name.REPLACE_ON_DUPLICATE_PK, protoOptions.getReplaceOnDuplicatePk());
        }
        if (protoOptions.hasPlanCachePrimaryMaxEntries()) {
            builder.withOption(Options.Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES, protoOptions.getPlanCachePrimaryMaxEntries());
        }
        if (protoOptions.hasPlanCacheSecondaryMaxEntries()) {
            builder.withOption(Options.Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES, protoOptions.getPlanCacheSecondaryMaxEntries());
        }
        if (protoOptions.hasPlanCacheTertiaryMaxEntries()) {
            builder.withOption(Options.Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES, protoOptions.getPlanCacheTertiaryMaxEntries());
        }
        if (protoOptions.hasPlanCachePrimaryTimeToLiveMillis()) {
            builder.withOption(Options.Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS, protoOptions.getPlanCachePrimaryTimeToLiveMillis());
        }
        if (protoOptions.hasPlanCacheSecondaryTimeToLiveMillis()) {
            builder.withOption(Options.Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS, protoOptions.getPlanCacheSecondaryTimeToLiveMillis());
        }
        if (protoOptions.hasPlanCacheTertiaryTimeToLiveMillis()) {
            builder.withOption(Options.Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS, protoOptions.getPlanCacheTertiaryTimeToLiveMillis());
        }
        if (protoOptions.hasIndexFetchMethod()) {
            Options.IndexFetchMethod indexFetchMethod;
            switch (protoOptions.getIndexFetchMethod()) {
                case SCAN_AND_FETCH: {
                    indexFetchMethod = Options.IndexFetchMethod.SCAN_AND_FETCH;
                    break;
                }
                case USE_REMOTE_FETCH: {
                    indexFetchMethod = Options.IndexFetchMethod.USE_REMOTE_FETCH;
                    break;
                }
                case USE_REMOTE_FETCH_WITH_FALLBACK: {
                    indexFetchMethod = Options.IndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK;
                    break;
                }
                default: {
                    throw new SQLException("Unknown fetch method");
                }
            }
            builder.withOption(Options.Name.INDEX_FETCH_METHOD, (Object)indexFetchMethod);
        }
        if (protoOptions.getDisabledPlannerRulesCount() > 0) {
            builder.withOption(Options.Name.DISABLED_PLANNER_RULES, protoOptions.getDisabledPlannerRulesList());
        }
        if (protoOptions.hasDisablePlannerRewriting()) {
            builder.withOption(Options.Name.DISABLE_PLANNER_REWRITING, protoOptions.getDisablePlannerRewriting());
        }
        if (protoOptions.hasLogQuery()) {
            builder.withOption(Options.Name.LOG_QUERY, protoOptions.getLogQuery());
        }
        if (protoOptions.hasLogSlowQueryThresholdMicros()) {
            builder.withOption(Options.Name.LOG_SLOW_QUERY_THRESHOLD_MICROS, protoOptions.getLogSlowQueryThresholdMicros());
        }
        if (protoOptions.hasExecutionTimeLimit()) {
            builder.withOption(Options.Name.EXECUTION_TIME_LIMIT, protoOptions.getExecutionTimeLimit());
        }
        if (protoOptions.hasExecutionScannedBytesLimit()) {
            builder.withOption(Options.Name.EXECUTION_SCANNED_BYTES_LIMIT, protoOptions.getExecutionScannedBytesLimit());
        }
        if (protoOptions.hasExecutionScannedRowsLimit()) {
            builder.withOption(Options.Name.EXECUTION_SCANNED_ROWS_LIMIT, protoOptions.getExecutionScannedRowsLimit());
        }
        if (protoOptions.hasDryRun()) {
            builder.withOption(Options.Name.DRY_RUN, protoOptions.getDryRun());
        }
        if (protoOptions.hasCaseSensitiveIdentifiers()) {
            builder.withOption(Options.Name.CASE_SENSITIVE_IDENTIFIERS, protoOptions.getCaseSensitiveIdentifiers());
        }
        if (protoOptions.hasCurrentPlanHashMode()) {
            builder.withOption(Options.Name.CURRENT_PLAN_HASH_MODE, protoOptions.getCurrentPlanHashMode());
        }
        if (protoOptions.hasValidPlanHashModes()) {
            builder.withOption(Options.Name.VALID_PLAN_HASH_MODES, protoOptions.getValidPlanHashModes());
        }
        if (protoOptions.hasContinuationsContainCompiledStatements() && !protoOptions.getContinuationsContainCompiledStatements()) {
            throw new RelationalException("Option CONTINUATIONS_CONTAIN_COMPILED_STATEMENTS=false not supported anymore!", ErrorCode.UNSUPPORTED_OPERATION).toUncheckedWrappedException();
        }
        if (protoOptions.hasAsyncOperationsTimeoutMillis()) {
            builder.withOption(Options.Name.ASYNC_OPERATIONS_TIMEOUT_MILLIS, protoOptions.getAsyncOperationsTimeoutMillis());
        }
        if (protoOptions.hasEncryptWhenSerializing()) {
            builder.withOption(Options.Name.ENCRYPT_WHEN_SERIALIZING, protoOptions.getEncryptWhenSerializing());
        }
        if (protoOptions.hasEncryptionKeyStore()) {
            builder.withOption(Options.Name.ENCRYPTION_KEY_STORE, protoOptions.getEncryptionKeyStore());
        }
        if (protoOptions.hasEncryptionKeyEntry()) {
            builder.withOption(Options.Name.ENCRYPTION_KEY_ENTRY, protoOptions.getEncryptionKeyEntry());
        }
        if (protoOptions.getEncryptionKeyEntryListCount() > 0) {
            builder.withOption(Options.Name.ENCRYPTION_KEY_ENTRY_LIST, protoOptions.getEncryptionKeyEntryListList());
        }
        if (protoOptions.hasEncryptionKeyPassword()) {
            builder.withOption(Options.Name.ENCRYPTION_KEY_PASSWORD, protoOptions.getEncryptionKeyPassword());
        }
        if (protoOptions.hasCompressWhenSerializing()) {
            builder.withOption(Options.Name.COMPRESS_WHEN_SERIALIZING, protoOptions.getCompressWhenSerializing());
        }
        return builder.build();
    }
}

