/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.jdbc.grpc;

import com.apple.foundationdb.annotation.API;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Code;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@API(value=API.Status.EXPERIMENTAL)
public final class GrpcSQLExceptionUtil {
    private static final Logger logger = LogManager.getLogger(GrpcSQLExceptionUtil.class.getName());
    private static final String SQLEXCEPTION_ERRORINFO_DOMAIN = GrpcSQLExceptionUtil.class.getPackageName();
    private static final String SQLEXCEPTION_ERROR_CODE = "sqlExceptionErrorCode";
    private static final String SQLEXCEPTION_SQLSTATE = "sqlExceptionSQLState";
    private static final String SQLEXCEPTION_CAUSE = "sqlExceptionCause";
    private static final String SQLEXCEPTION_CAUSE_MESSAGE = "sqlExceptionCauseMessage";
    private static final String SQLEXCEPTION_STACK_TRACE = "sqlExceptionStackTrace";
    private static final int CODE_ON_SQLEXCEPTION = Code.UNKNOWN.getNumber();

    private GrpcSQLExceptionUtil() {
    }

    static ErrorInfo map(SQLException sqlException) {
        ErrorInfo.Builder builder = ErrorInfo.newBuilder();
        builder.setDomain(SQLEXCEPTION_ERRORINFO_DOMAIN);
        builder.setReason(sqlException.getClass().getName());
        builder.putMetadata(SQLEXCEPTION_ERROR_CODE, Integer.toString(sqlException.getErrorCode()));
        if (sqlException.getSQLState() != null) {
            builder.putMetadata(SQLEXCEPTION_SQLSTATE, sqlException.getSQLState());
        }
        if (sqlException.getCause() != null) {
            Throwable cause = sqlException.getCause();
            builder.putMetadata(SQLEXCEPTION_CAUSE, cause.getClass().getName());
            if (cause.getMessage() != null) {
                builder.putMetadata(SQLEXCEPTION_CAUSE_MESSAGE, cause.getMessage());
            }
        }
        if (sqlException.getStackTrace() != null) {
            builder.putMetadata(SQLEXCEPTION_STACK_TRACE, GrpcSQLExceptionUtil.stacktraceToString(sqlException));
        }
        return builder.build();
    }

    public static Status create(SQLException sqlException) {
        return Status.newBuilder().setCode(CODE_ON_SQLEXCEPTION).setMessage(sqlException.getMessage() != null ? sqlException.getMessage() : "").addDetails(Any.pack(GrpcSQLExceptionUtil.map(sqlException))).build();
    }

    @Nullable
    public static SQLException map(StatusRuntimeException statusRuntimeException) {
        Status status = StatusProto.fromThrowable(statusRuntimeException);
        return GrpcSQLExceptionUtil.map(status);
    }

    @Nullable
    public static SQLException map(Status status) {
        if (status.getCode() != CODE_ON_SQLEXCEPTION) {
            return null;
        }
        ErrorInfo errorInfo = null;
        for (Any any : status.getDetailsList()) {
            if (!any.is(ErrorInfo.class)) {
                logger.warn("Non-ErrorInfo Any type found: {} in {}", (Object)any.getClass(), (Object)status);
                continue;
            }
            try {
                if (errorInfo != null) {
                    logger.warn("More than one ErrorInfo found in {}, using first-found", (Object)status);
                    continue;
                }
                ErrorInfo ei = any.unpack(ErrorInfo.class);
                if (ei.getDomain() == null || !ei.getDomain().equals(SQLEXCEPTION_ERRORINFO_DOMAIN)) continue;
                errorInfo = ei;
            }
            catch (InvalidProtocolBufferException e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn(e.getMessage());
            }
        }
        return errorInfo == null ? null : GrpcSQLExceptionUtil.map(status.getMessage(), errorInfo);
    }

    @Nullable
    private static Throwable getCause(ErrorInfo errorInfo) {
        String causeExceptionName = errorInfo.getMetadataOrDefault(SQLEXCEPTION_CAUSE, null);
        if (causeExceptionName == null) {
            return null;
        }
        String causeMessage = errorInfo.getMetadataOrDefault(SQLEXCEPTION_CAUSE_MESSAGE, null);
        try {
            Class<?> clazz = Class.forName(causeExceptionName);
            if (causeMessage == null) {
                return (Throwable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
            return (Throwable)constructor.newInstance(causeMessage);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (logger.isTraceEnabled()) {
                logger.trace(e.getMessage());
            }
            return null;
        }
    }

    private static SQLException map(String message, ErrorInfo errorInfo) {
        Throwable cause;
        int vendorErrorCode;
        String sqlState;
        block5: {
            String sqlExceptionName;
            sqlState = errorInfo.getMetadataOrDefault(SQLEXCEPTION_SQLSTATE, null);
            vendorErrorCode = Integer.parseInt(errorInfo.getMetadataOrDefault(SQLEXCEPTION_ERROR_CODE, "-1"));
            cause = GrpcSQLExceptionUtil.getCause(errorInfo);
            String stackTrace = errorInfo.getMetadataOrDefault(SQLEXCEPTION_STACK_TRACE, "");
            if (stackTrace != null && stackTrace.startsWith(message)) {
                message = stackTrace;
            }
            if ((sqlExceptionName = errorInfo.getReason()) != null && !sqlExceptionName.equals(SQLException.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(sqlExceptionName);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, Integer.TYPE, Throwable.class);
                    if (constructor != null) {
                        return (SQLException)constructor.newInstance(message, sqlState, vendorErrorCode, cause);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    if (!logger.isTraceEnabled() || e.getMessage() == null) break block5;
                    logger.trace(e.getMessage());
                }
            }
        }
        return new SQLException(message, sqlState, vendorErrorCode, cause);
    }

    public static String stacktraceToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String str = stringWriter.toString();
        int maxSize = 4096;
        return str.length() <= 4096 ? str : str.substring(0, 4096);
    }
}

