/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.catalog.RelationalDatabase;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractDatabase
implements RelationalDatabase {
    @Nonnull
    private final MetadataOperationsFactory metadataOperationsFactory;
    @Nonnull
    private final DdlQueryFactory ddlQueryFactory;
    @Nullable
    protected EmbeddedRelationalConnection connection;
    final Map<String, RecordLayerSchema> schemas = new HashMap<String, RecordLayerSchema>();
    @Nullable
    private final RelationalPlanCache planCache;
    @Nonnull
    protected Options options;

    public AbstractDatabase(@Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull DdlQueryFactory ddlQueryFactory, @Nullable RelationalPlanCache planCache, @Nonnull Options options) {
        this.metadataOperationsFactory = metadataOperationsFactory;
        this.ddlQueryFactory = ddlQueryFactory;
        this.planCache = planCache;
        this.options = options;
    }

    protected void setConnection(@Nonnull EmbeddedRelationalConnection conn) {
        this.connection = conn;
    }

    @Nonnull
    protected Transaction getCurrentTransaction() throws RelationalException {
        if (this.connection == null) {
            throw new RelationalException("Connection not set!", ErrorCode.INTERNAL_ERROR);
        }
        return this.connection.getTransaction();
    }

    @Override
    @Nonnull
    public RecordLayerSchema loadSchema(@Nonnull String schemaId) throws RelationalException {
        RecordLayerSchema schema = this.schemas.get(schemaId);
        boolean putBack = false;
        if (schema == null) {
            schema = new RecordLayerSchema(schemaId, this, this.connection);
            putBack = true;
        }
        if (putBack) {
            this.schemas.put(schemaId, schema);
            this.getCurrentTransaction().unwrap(RecordContextTransaction.class).addTerminationListener(() -> {
                RecordLayerSchema rlSchema = this.schemas.remove(schemaId);
                try {
                    if (rlSchema != null) {
                        rlSchema.close();
                    }
                }
                catch (RelationalException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return schema;
    }

    @Override
    @Nonnull
    public MetadataOperationsFactory getDdlFactory() {
        return this.metadataOperationsFactory;
    }

    @Nonnull
    public DdlQueryFactory getDdlQueryFactory() {
        return this.ddlQueryFactory;
    }

    public abstract BackingStore loadRecordStore(@Nonnull String var1, @Nonnull FDBRecordStoreBase.StoreExistenceCheck var2) throws RelationalException;

    public abstract URI getURI();

    public abstract TransactionManager getTransactionManager();

    @Nullable
    public RelationalPlanCache getPlanCache() {
        return this.planCache;
    }

    @Nonnull
    public Options getOptions() {
        return this.options;
    }

    public void setOption(@Nonnull Options.Name name, Object value) throws SQLException {
        this.options = this.options.withOption(name, value);
    }
}

