/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.api.metrics.RelationalMetric;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.ErrorCapturingResultSet;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.query.Plan;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.PlanGenerator;
import com.apple.foundationdb.relational.recordlayer.query.QueryPlan;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractEmbeddedStatement
implements Statement {
    @Nonnull
    final EmbeddedRelationalConnection conn;
    @Nullable
    RelationalResultSet currentResultSet;
    boolean resultSetRetrieved = true;
    boolean closed;
    int currentRowCount;
    Options options;

    public AbstractEmbeddedStatement(@Nonnull EmbeddedRelationalConnection conn) {
        this.conn = conn;
        this.options = conn.getOptions();
    }

    @Nonnull
    abstract PlanContext createPlanContext(@Nonnull FDBRecordStoreBase<?> var1, @Nonnull Options var2) throws RelationalException;

    public boolean executeInternal(String sql) throws SQLException, RelationalException {
        this.closeOpenResultSets();
        this.checkOpen();
        Assert.notNull(sql);
        this.conn.ensureTransactionActive();
        MetricCollector metricCollector = Assert.notNullUnchecked(this.conn.getMetricCollector());
        return metricCollector.clock(RelationalMetric.RelationalEvent.TOTAL_PROCESS_QUERY, () -> {
            try {
                if (this.conn.getSchema() == null) {
                    throw new RelationalException("No Schema specified", ErrorCode.UNDEFINED_SCHEMA);
                }
                try (RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(this.conn.getSchema());){
                    Optional<RelationalPlanCache> planCacheMaybe = Optional.ofNullable(this.conn.getRecordLayerDatabase().getPlanCache());
                    FDBRecordStoreBase store = schema.loadStore().unwrap(FDBRecordStoreBase.class);
                    PlanGenerator planGenerator = PlanGenerator.create(planCacheMaybe, this.createPlanContext(store, this.options), store, this.options);
                    Plan<?> plan = planGenerator.getPlan(sql);
                    Plan.ExecutionContext executionContext = Plan.ExecutionContext.of(this.conn.getTransaction(), planGenerator.getOptions(), this.conn, metricCollector);
                    if (plan instanceof QueryPlan) {
                        this.currentResultSet = new ErrorCapturingResultSet((RelationalResultSet)((QueryPlan)plan).execute(executionContext));
                        this.resultSetRetrieved = false;
                        if (plan.isUpdatePlan()) {
                            try (RelationalResultSet updateResultSet = this.currentResultSet;){
                                this.currentResultSet = null;
                                this.resultSetRetrieved = true;
                                this.currentRowCount = this.countUpdates(updateResultSet);
                                Boolean bl = false;
                                return bl;
                            }
                        }
                        this.currentRowCount = -1;
                        Boolean bl = true;
                        return bl;
                    }
                    plan.execute(executionContext);
                    this.currentResultSet = null;
                    this.resultSetRetrieved = true;
                    this.currentRowCount = 0;
                    if (this.conn.canCommit()) {
                        this.conn.commitInternal();
                    }
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (RelationalException | RuntimeException | SQLException ex) {
                try {
                    if (!this.conn.inActiveTransaction()) throw ExceptionUtil.toRelationalException(ex);
                    if (!this.conn.canCommit()) throw ExceptionUtil.toRelationalException(ex);
                    this.conn.rollbackInternal();
                    throw ExceptionUtil.toRelationalException(ex);
                }
                catch (SQLException e) {
                    ex.addSuppressed(e);
                    throw ExceptionUtil.toRelationalException(e);
                }
            }
        });
    }

    @Override
    public RelationalResultSet getResultSet() throws SQLException {
        this.checkOpen();
        if (this.currentResultSet != null && !this.resultSetRetrieved) {
            Assert.thatUnchecked(!this.currentResultSet.isClosed(), ErrorCode.INTERNAL_ERROR, "ResultSet exists but is closed");
            this.resultSetRetrieved = true;
            return this.currentResultSet;
        }
        throw new SQLException("no open result set available");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.currentResultSet != null) {
            return -1;
        }
        return this.currentRowCount;
    }

    @Override
    public RelationalConnection getConnection() throws SQLException {
        this.checkOpen();
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.closeOpenResultSets();
            this.closed = true;
        }
        catch (RuntimeException ex) {
            if (this.conn.canCommit()) {
                try {
                    this.conn.rollbackInternal();
                }
                catch (SQLException e) {
                    e.addSuppressed(ex);
                    throw e;
                }
            }
            throw ExceptionUtil.toRelationalException(ex).toSqlException();
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed) {
            throw new RelationalException("Statement closed", ErrorCode.STATEMENT_CLOSED).toSqlException();
        }
    }

    private int countUpdates(@Nonnull ResultSet resultSet) throws SQLException {
        int count = 0;
        try {
            while (resultSet.next()) {
                ++count;
            }
            if (this.conn.canCommit()) {
                this.conn.commitInternal();
            }
            return count;
        }
        catch (RuntimeException | SQLException ex) {
            if (this.conn.canCommit()) {
                this.conn.rollbackInternal();
            }
            throw ExceptionUtil.toRelationalException(ex).toSqlException();
        }
    }

    private void closeOpenResultSets() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        this.resultSetRetrieved = true;
    }

    @Override
    public int getMaxRows() throws SQLException {
        int pageSize = (Integer)this.options.getOption(Options.Name.MAX_ROWS);
        if (pageSize == Integer.MAX_VALUE) {
            return 0;
        }
        return pageSize;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max == 0) {
            max = Integer.MAX_VALUE;
        }
        this.options = Options.builder().fromOptions(this.options).withOption(Options.Name.MAX_ROWS, max).build();
    }
}

