/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.relational.api.MutableRowStruct;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalResultSetMetaData;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.StructResultSetMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import java.sql.SQLException;
import java.util.UUID;

public abstract class AbstractRecordLayerResultSet
implements RelationalResultSet {
    protected final StructMetaData metaData;
    private final MutableRowStruct currentRow;

    public AbstractRecordLayerResultSet(StructMetaData metaData) {
        this.metaData = metaData;
        this.currentRow = new MutableRowStruct(metaData);
    }

    protected abstract boolean hasNext();

    protected abstract Row advanceRow() throws RelationalException;

    @Override
    public boolean next() throws SQLException {
        try {
            Row next = this.advanceRow();
            this.currentRow.setRow(next);
            return next != null;
        }
        catch (RelationalException ve) {
            throw ve.toSqlException();
        }
    }

    @Override
    public boolean wasNull() {
        return this.currentRow.wasNull();
    }

    @Override
    public boolean getBoolean(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getBoolean(oneBasedPosition);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getBoolean(columnLabel);
    }

    @Override
    public byte[] getBytes(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getBytes(oneBasedPosition);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getBytes(columnLabel);
    }

    @Override
    public int getInt(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getInt(oneBasedPosition);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getInt(columnLabel);
    }

    @Override
    public long getLong(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getLong(oneBasedPosition);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getLong(columnLabel);
    }

    @Override
    public float getFloat(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getFloat(oneBasedPosition);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getFloat(columnLabel);
    }

    @Override
    public double getDouble(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getDouble(oneBasedPosition);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getDouble(columnLabel);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getObject(columnLabel);
    }

    @Override
    public Object getObject(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getObject(oneBasedPosition);
    }

    @Override
    public String getString(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getString(oneBasedPosition);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getString(columnLabel);
    }

    @Override
    public RelationalArray getArray(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getArray(oneBasedPosition);
    }

    @Override
    public RelationalArray getArray(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getArray(columnLabel);
    }

    @Override
    public UUID getUUID(int oneBasedPosition) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getUUID(oneBasedPosition);
    }

    @Override
    public UUID getUUID(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getUUID(columnLabel);
    }

    @Override
    public RelationalStruct getStruct(int oneBasedColumn) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getStruct(oneBasedColumn);
    }

    @Override
    public RelationalStruct getStruct(String columnLabel) throws SQLException {
        if (!this.currentRow.hasRow()) {
            throw new SQLException("ResultSet exhausted", ErrorCode.INVALID_CURSOR_STATE.getErrorCode());
        }
        return this.currentRow.getStruct(columnLabel);
    }

    @Override
    public RelationalResultSetMetaData getMetaData() {
        return new StructResultSetMetaData(this.metaData);
    }
}

