/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.api.exceptions.InvalidTypeException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.FDBTuple;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.ValueTuple;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public abstract class AbstractRow
implements Row {
    @Override
    public long getLong(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (!(o instanceof Number)) {
            throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a scalar type");
        }
        return ((Number)o).longValue();
    }

    @Override
    public float getFloat(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (!(o instanceof Number)) {
            throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a float type");
        }
        return ((Number)o).floatValue();
    }

    @Override
    public double getDouble(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (!(o instanceof Number)) {
            throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a double type");
        }
        return ((Number)o).doubleValue();
    }

    @Override
    public String getString(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        if (o instanceof Descriptors.EnumValueDescriptor) {
            return ((Descriptors.EnumValueDescriptor)o).getName();
        }
        if (!(o instanceof String)) {
            throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a String");
        }
        return (String)o;
    }

    @Override
    public byte[] getBytes(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (!(o instanceof byte[])) {
            throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a byte[]");
        }
        return (byte[])o;
    }

    @Override
    public Row getRow(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (o instanceof Row) {
            return (Row)o;
        }
        if (o instanceof Tuple) {
            return new FDBTuple((Tuple)o);
        }
        if (o instanceof Message) {
            return new MessageTuple((Message)o);
        }
        throw new InvalidTypeException("Value <" + String.valueOf(o) + "> cannot be cast to a tuple");
    }

    @Override
    public Iterable<Row> getArray(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Object o = this.getObject(position);
        if (o instanceof Iterable) {
            return StreamSupport.stream(((Iterable)o).spliterator(), false).map(obj -> {
                if (obj instanceof Row) {
                    return (Row)obj;
                }
                if (obj instanceof Tuple) {
                    return new FDBTuple((Tuple)obj);
                }
                return new ValueTuple(obj);
            }).collect(Collectors.toList());
        }
        throw new InvalidTypeException("Object <" + String.valueOf(o) + "> cannot be converted to a repeated type");
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Row)) {
            return false;
        }
        Row otherTuple = (Row)other;
        int numFields = this.getNumFields();
        if (numFields != otherTuple.getNumFields()) {
            return false;
        }
        for (int i = 0; i < numFields; ++i) {
            try {
                Object lhs = this.getObject(i);
                Object rhs = otherTuple.getObject(i);
                if (lhs instanceof Collection && rhs instanceof Collection) {
                    Collection lhsCollection = (Collection)lhs;
                    Collection rhsCollection = (Collection)rhs;
                    if (lhsCollection.size() != rhsCollection.size()) {
                        return false;
                    }
                    return Streams.zip(lhsCollection.stream(), rhsCollection.stream(), AbstractRow::areEqual).allMatch(t2 -> t2);
                }
                if (AbstractRow.areEqual(lhs, rhs)) continue;
                return false;
            }
            catch (InvalidColumnReferenceException e) {
                throw e.toUncheckedWrappedException();
            }
        }
        return true;
    }

    private static boolean areEqual(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Object rhsMessage = rhs instanceof Message ? new MessageTuple((Message)rhs) : rhs;
        Object lhsMessage = lhs instanceof Message ? new MessageTuple((Message)lhs) : lhs;
        return Objects.equals(lhsMessage, rhsMessage);
    }

    public int hashCode() {
        if (this.getNumFields() == 0) {
            return 0;
        }
        return Objects.hash(IntStream.range(0, this.getNumFields()).mapToObj(position -> {
            try {
                return this.getObject(position);
            }
            catch (InvalidColumnReferenceException e) {
                throw e.toUncheckedWrappedException();
            }
        }).toArray());
    }

    @Override
    public boolean startsWith(Row prefix) {
        if (prefix.getNumFields() > this.getNumFields()) {
            return false;
        }
        return this.getPrefix(prefix.getNumFields()).equals(prefix);
    }

    @Override
    public Row getPrefix(final int length) {
        final AbstractRow thisRow = this;
        return new AbstractRow(){

            @Override
            public int getNumFields() {
                return Math.min(thisRow.getNumFields(), length);
            }

            @Override
            public Object getObject(int position) throws InvalidColumnReferenceException {
                if (position > this.getNumFields()) {
                    throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
                }
                return thisRow.getObject(position);
            }
        };
    }

    public String toString() {
        try {
            int numCols = this.getNumFields();
            StringBuilder sb = new StringBuilder("(");
            boolean isFirst = true;
            for (int i = 0; i < numCols; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                Object colValue = this.getObject(i);
                if (colValue instanceof Object[]) {
                    sb.append("Array").append(Arrays.toString((Object[])colValue));
                    continue;
                }
                if (colValue instanceof Collection) {
                    String fieldVals = ((Collection)colValue).stream().map(obj -> obj == null ? "NULL" : obj.toString()).collect(Collectors.joining(", "));
                    sb.append("Array[").append(fieldVals).append("]");
                    continue;
                }
                if (colValue instanceof byte[]) {
                    sb.append("ByteArray[").append(ByteArrayUtil2.toHexString((byte[])colValue)).append("]");
                    continue;
                }
                sb.append(colValue);
            }
            return sb.append(")").toString();
        }
        catch (RelationalException ve) {
            throw ve.toUncheckedWrappedException();
        }
    }
}

