/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.recordlayer.AbstractRow;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.function.Supplier;

@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentionally exposed for performance reasons")
@API(value=API.Status.EXPERIMENTAL)
public class ArrayRow
extends AbstractRow {
    private final Object[] data;
    private final Supplier<Integer> hashCodeSupplier;

    public ArrayRow(Object ... data) {
        this.data = data;
        this.hashCodeSupplier = Suppliers.memoize(() -> Arrays.deepHashCode(data));
    }

    @Override
    public int getNumFields() {
        return this.data.length;
    }

    @Override
    public Object getObject(int position) throws InvalidColumnReferenceException {
        if (position < 0 || position >= this.data.length) {
            throw new InvalidColumnReferenceException(Integer.toString(position));
        }
        return this.data[position];
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ArrayRow)) {
            return false;
        }
        ArrayRow otherArrayRow = (ArrayRow)other;
        if (otherArrayRow == this) {
            return true;
        }
        if (this.data.length != otherArrayRow.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (!(this.data[i] == null ? otherArrayRow.data[i] != null : (this.data[i] instanceof byte[] ? !(otherArrayRow.data[i] instanceof byte[]) || !Arrays.equals((byte[])this.data[i], (byte[])otherArrayRow.data[i]) : !this.data[i].equals(otherArrayRow.data[i])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCodeSupplier.get();
    }
}

