/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.relational.api.RelationalDatabaseMetaData;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.ProtobufDdlUtil;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.OperationUnsupportedException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.Schema;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.IteratorResultSet;
import com.apple.foundationdb.relational.recordlayer.catalog.CatalogMetaDataProvider;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.metadata.RecordLayerSchemaTemplate;
import com.apple.foundationdb.relational.util.Assert;
import com.google.protobuf.Descriptors;
import java.net.URI;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CatalogMetaData
implements RelationalDatabaseMetaData {
    private final StoreCatalog catalog;
    private final EmbeddedRelationalConnection conn;

    public CatalogMetaData(EmbeddedRelationalConnection conn, StoreCatalog catalog) {
        this.catalog = catalog;
        this.conn = conn;
    }

    @Override
    @Nonnull
    public RelationalResultSet getSchemas() throws SQLException {
        return this.getSchemas(this.conn.getPath().getPath(), null);
    }

    @Override
    public RelationalResultSet getSchemas(String catalogStr, String schemaPattern) throws SQLException {
        if (catalogStr == null) {
            throw new OperationUnsupportedException("Must use a non-null catalog name currently").toSqlException();
        }
        return this.conn.runIsolatedInTransactionIfPossible(() -> {
            IteratorResultSet iteratorResultSet;
            block9: {
                RelationalResultSet rrs = this.catalog.listSchemas(this.conn.getTransaction(), URI.create(catalogStr), ContinuationImpl.BEGIN);
                try {
                    ArrayList<ArrayRow> simplifiedRows = new ArrayList<ArrayRow>();
                    while (rrs.next()) {
                        Object[] data = new Object[]{this.conn.getPath(), rrs.getString("SCHEMA_NAME")};
                        simplifiedRows.add(new ArrayRow(data));
                    }
                    DataType.StructType schemasStructType = DataType.StructType.from("SCHEMAS", List.of(DataType.StructType.Field.from("TABLE_CATALOG", DataType.Primitives.NULLABLE_STRING.type(), 0), DataType.StructType.Field.from("TABLE_SCHEM", DataType.Primitives.NULLABLE_STRING.type(), 1)), true);
                    iteratorResultSet = new IteratorResultSet(RelationalStructMetaData.of(schemasStructType), simplifiedRows.iterator(), 0);
                    if (rrs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (rrs != null) {
                            try {
                                rrs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sqle) {
                        throw new RelationalException(sqle);
                    }
                }
                rrs.close();
            }
            return iteratorResultSet;
        });
    }

    @Override
    @Nonnull
    public RelationalResultSet getTables(String database, String schema, String tableName, String[] types) throws SQLException {
        if (database == null) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Databases yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (schema == null) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Schemas yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (tableName != null) {
            throw new SQLFeatureNotSupportedException("Table filters on getTables() is not supported yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (types != null) {
            throw new SQLFeatureNotSupportedException("Type filters on getTables() is not supported yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        return this.conn.runIsolatedInTransactionIfPossible(() -> {
            RecordMetaDataProto.MetaData schemaInfo = this.loadSchemaMetadata(database, schema);
            List tableList = schemaInfo.getRecordTypesList().stream().map(type -> new Object[]{database, schema, type.getName(), type.hasSinceVersion() ? Integer.valueOf(type.getSinceVersion()) : null}).map(ArrayRow::new).collect(Collectors.toList());
            DataType.StructType tablesStructType = DataType.StructType.from("TABLES", List.of(DataType.StructType.Field.from("TABLE_CAT", DataType.Primitives.NULLABLE_STRING.type(), 0), DataType.StructType.Field.from("TABLE_SCHEM", DataType.Primitives.NULLABLE_STRING.type(), 1), DataType.StructType.Field.from("TABLE_NAME", DataType.Primitives.NULLABLE_STRING.type(), 2), DataType.StructType.Field.from("TABLE_VERSION", DataType.Primitives.NULLABLE_LONG.type(), 3)), true);
            return new IteratorResultSet(RelationalStructMetaData.of(tablesStructType), tableList.iterator(), 0);
        });
    }

    @Override
    public RelationalResultSet getPrimaryKeys(String database, String schema, String table) throws SQLException {
        return this.conn.runIsolatedInTransactionIfPossible(() -> {
            RecordMetaDataProto.MetaData schemaInfo = this.loadSchemaMetadata(database, schema);
            Stream rows = schemaInfo.getRecordTypesList().stream().filter(type -> type.getName().equals(table)).map(type -> {
                RecordKeyExpressionProto.KeyExpression ke = type.getPrimaryKey();
                return new AbstractMap.SimpleEntry<String, String[]>(type.getName(), this.keyExpressionToPrimaryKey(ke));
            }).flatMap(pks -> IntStream.range(0, ((String[])pks.getValue()).length).mapToObj(pos -> new ArrayRow(database, schema, pks.getKey(), ((String[])pks.getValue())[pos], pos + 1, null)));
            DataType.StructType primaryKeysStructType = DataType.StructType.from("PRIMARY_KEYS", List.of(DataType.StructType.Field.from("TABLE_CAT", DataType.Primitives.NULLABLE_STRING.type(), 0), DataType.StructType.Field.from("TABLE_SCHEM", DataType.Primitives.NULLABLE_STRING.type(), 1), DataType.StructType.Field.from("TABLE_NAME", DataType.Primitives.NULLABLE_STRING.type(), 2), DataType.StructType.Field.from("COLUMN_NAME", DataType.Primitives.NULLABLE_STRING.type(), 3), DataType.StructType.Field.from("KEY_SEQ", DataType.Primitives.NULLABLE_INTEGER.type(), 4), DataType.StructType.Field.from("PK_NAME", DataType.Primitives.NULLABLE_STRING.type(), 5)), true);
            return new IteratorResultSet(RelationalStructMetaData.of(primaryKeysStructType), rows.iterator(), 0);
        });
    }

    @Override
    @Nonnull
    public RelationalResultSet getColumns(String database, String schema, String tablePattern, String columnPattern) throws SQLException {
        if (database == null || database.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Databases yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Schemas yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (tablePattern == null || tablePattern.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Table must be specified", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (columnPattern != null) {
            throw new SQLFeatureNotSupportedException("Column filters on getColumns() is not supported yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        return this.conn.runIsolatedInTransactionIfPossible(() -> {
            RecordMetaData rmd = new CatalogMetaDataProvider(this.catalog, URI.create(database), schema, this.conn.getTransaction()).getRecordMetaData();
            Descriptors.FileDescriptor fileDesc = rmd.getRecordsDescriptor();
            try {
                rmd.getRecordType(tablePattern);
            }
            catch (MetaDataException mde) {
                throw new RelationalException("table <" + tablePattern + "> does not exist", ErrorCode.UNDEFINED_TABLE);
            }
            Descriptors.Descriptor tableDescriptor = fileDesc.findMessageTypeByName(tablePattern);
            List columnDefs = tableDescriptor.getFields().stream().map(field -> {
                Object[] row = new Object[]{database, schema, tablePattern, field.getName(), ProtobufDdlUtil.getSqlType(field), ProtobufDdlUtil.getTypeName(field), -1, 0, null, null, 2, null, field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE ? field.getDefaultValue() : null, -1, -1, -1, field.getIndex() + 1, "YES", null, null, null, null, "NO", "NO"};
                return new ArrayRow(row);
            }).collect(Collectors.toList());
            DataType.StructType columnsStructType = DataType.StructType.from("PRIMARY_KEYS", List.of(DataType.StructType.Field.from("TABLE_CAT", DataType.Primitives.NULLABLE_STRING.type(), 0), DataType.StructType.Field.from("TABLE_SCHEM", DataType.Primitives.NULLABLE_STRING.type(), 1), DataType.StructType.Field.from("TABLE_NAME", DataType.Primitives.NULLABLE_STRING.type(), 2), DataType.StructType.Field.from("COLUMN_NAME", DataType.Primitives.NULLABLE_STRING.type(), 3), DataType.StructType.Field.from("DATA_TYPE", DataType.Primitives.NULLABLE_STRING.type(), 4), DataType.StructType.Field.from("TYPE_NAME", DataType.Primitives.NULLABLE_STRING.type(), 5), DataType.StructType.Field.from("COLUMN_SIZE", DataType.Primitives.NULLABLE_INTEGER.type(), 6), DataType.StructType.Field.from("BUFFER_LENGTH", DataType.Primitives.NULLABLE_INTEGER.type(), 7), DataType.StructType.Field.from("DECIMAL_DIGITS", DataType.Primitives.NULLABLE_INTEGER.type(), 8), DataType.StructType.Field.from("NUM_PREC_RADIX", DataType.Primitives.NULLABLE_INTEGER.type(), 9), DataType.StructType.Field.from("NULLABLE", DataType.Primitives.NULLABLE_INTEGER.type(), 10), DataType.StructType.Field.from("REMARKS", DataType.Primitives.NULLABLE_STRING.type(), 11), DataType.StructType.Field.from("COLUMN_DEF", DataType.Primitives.NULLABLE_STRING.type(), 12), DataType.StructType.Field.from("SQL_DATA_TYPE", DataType.Primitives.NULLABLE_INTEGER.type(), 13), DataType.StructType.Field.from("SQL_DATETIME_SUB", DataType.Primitives.NULLABLE_INTEGER.type(), 14), DataType.StructType.Field.from("CHAR_OCTET_LENGTH", DataType.Primitives.NULLABLE_INTEGER.type(), 15), DataType.StructType.Field.from("ORDINAL_POSITION", DataType.Primitives.NULLABLE_INTEGER.type(), 16), DataType.StructType.Field.from("IS_NULLABLE", DataType.Primitives.NULLABLE_STRING.type(), 17), DataType.StructType.Field.from("SCOPE_CATALOG", DataType.Primitives.NULLABLE_STRING.type(), 18), DataType.StructType.Field.from("SCOPE_SCHEMA", DataType.Primitives.NULLABLE_STRING.type(), 19), DataType.StructType.Field.from("SCOPE_TABLE", DataType.Primitives.NULLABLE_STRING.type(), 20), DataType.StructType.Field.from("SOURCE_DATA_TYPE", DataType.Primitives.NULLABLE_INTEGER.type(), 21), DataType.StructType.Field.from("IS_AUTOINCREMENT", DataType.Primitives.NULLABLE_STRING.type(), 22), DataType.StructType.Field.from("IS_GENERATEDCOLUMN", DataType.Primitives.NULLABLE_STRING.type(), 23)), true);
            return new IteratorResultSet(RelationalStructMetaData.of(columnsStructType), columnDefs.iterator(), 0);
        });
    }

    @Override
    public RelationalResultSet getIndexInfo(String database, String schema, String tablePattern, boolean unique, boolean approximate) throws SQLException {
        if (database == null || database.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Databases yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Cannot scan across Schemas yet", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (tablePattern == null || tablePattern.isEmpty()) {
            throw new SQLFeatureNotSupportedException("Table must be specified", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        return this.conn.runIsolatedInTransactionIfPossible(() -> {
            List indexDefs;
            RecordMetaData rmd = RecordMetaData.build(this.loadSchemaMetadata(database, schema));
            try {
                RecordType recordType = rmd.getRecordType(tablePattern);
                List<Index> indexes = recordType.getIndexes();
                indexDefs = indexes.stream().map(index -> {
                    Object[] row = new Object[]{database, schema, recordType.getName(), index.isUnique(), index.getType(), index.getName(), (short)3, -1, null, null, -1, -1, null};
                    return new ArrayRow(row);
                }).collect(Collectors.toList());
            }
            catch (MetaDataException mde) {
                throw new RelationalException("table <" + tablePattern + "> does not exist", ErrorCode.UNDEFINED_TABLE);
            }
            DataType.StructType indexInfoStructType = DataType.StructType.from("PRIMARY_KEYS", List.of(DataType.StructType.Field.from("TABLE_CAT", DataType.Primitives.NULLABLE_STRING.type(), 0), DataType.StructType.Field.from("TABLE_SCHEM", DataType.Primitives.NULLABLE_STRING.type(), 1), DataType.StructType.Field.from("TABLE_NAME", DataType.Primitives.NULLABLE_STRING.type(), 2), DataType.StructType.Field.from("NON_UNIQUE", DataType.Primitives.NULLABLE_BOOLEAN.type(), 3), DataType.StructType.Field.from("INDEX_QUALIFIER", DataType.Primitives.NULLABLE_STRING.type(), 4), DataType.StructType.Field.from("INDEX_NAME", DataType.Primitives.NULLABLE_STRING.type(), 5), DataType.StructType.Field.from("TYPE", DataType.Primitives.NULLABLE_STRING.type(), 6), DataType.StructType.Field.from("ORDINAL_POSITION", DataType.Primitives.NULLABLE_INTEGER.type(), 7), DataType.StructType.Field.from("COLUMN_NAME", DataType.Primitives.NULLABLE_STRING.type(), 8), DataType.StructType.Field.from("ASC_OR_DESC", DataType.Primitives.NULLABLE_STRING.type(), 9), DataType.StructType.Field.from("CARDINALITY", DataType.Primitives.NULLABLE_INTEGER.type(), 10), DataType.StructType.Field.from("PAGES", DataType.Primitives.NULLABLE_INTEGER.type(), 11), DataType.StructType.Field.from("FILTER_CONDITION", DataType.Primitives.NULLABLE_STRING.type(), 12)), true);
            return new IteratorResultSet(RelationalStructMetaData.of(indexInfoStructType), indexDefs.iterator(), 0);
        });
    }

    @Nonnull
    private RecordMetaDataProto.MetaData loadSchemaMetadata(@Nonnull String database, @Nonnull String schema) throws RelationalException {
        Schema recLayerSchema = this.catalog.loadSchema(this.conn.getTransaction(), URI.create(database), schema);
        Assert.thatUnchecked(recLayerSchema instanceof RecordLayerSchema);
        return recLayerSchema.getSchemaTemplate().unwrap(RecordLayerSchemaTemplate.class).toRecordMetadata().toProto();
    }

    private String[] keyExpressionToPrimaryKey(RecordKeyExpressionProto.KeyExpression ke) throws UncheckedRelationalException {
        if (ke.hasThen()) {
            List<RecordKeyExpressionProto.KeyExpression> childList = ke.getThen().getChildList();
            String[] fields = new String[childList.size()];
            int pos = 0;
            for (RecordKeyExpressionProto.KeyExpression childKe : childList) {
                if (childKe.hasRecordTypeKey() || !childKe.hasField()) continue;
                fields[pos] = childKe.getField().getFieldName();
                ++pos;
            }
            if (pos < fields.length) {
                fields = Arrays.copyOf(fields, pos);
            }
            return fields;
        }
        throw new OperationUnsupportedException("Unexpected Primary Key structure").toUncheckedWrappedException();
    }
}

