/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.continuation.CompiledStatement;
import com.apple.foundationdb.relational.continuation.ContinuationProto;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ContinuationBuilder {
    @Nonnull
    private final ContinuationProto.Builder proto;

    public ContinuationBuilder() {
        this.proto = ContinuationProto.newBuilder();
    }

    public ContinuationBuilder(@Nonnull ContinuationProto proto) {
        this.proto = proto.toBuilder();
    }

    @Nonnull
    public ContinuationBuilder withExecutionState(byte[] executionState) {
        this.proto.setExecutionState(ByteString.copyFrom(executionState));
        return this;
    }

    @Nonnull
    public ContinuationBuilder withBindingHash(int hash) {
        this.proto.setBindingHash(hash);
        return this;
    }

    @Nonnull
    public ContinuationBuilder withPlanHash(int hash) {
        this.proto.setPlanHash(hash);
        return this;
    }

    @Nonnull
    public ContinuationBuilder withCompiledStatement(@Nonnull CompiledStatement compiledStatementProto) {
        this.proto.setCompiledStatement(compiledStatementProto);
        return this;
    }

    @Nonnull
    public ContinuationBuilder withReason(@Nonnull Continuation.Reason reason) {
        this.proto.setReason(ContinuationProto.Reason.valueOf(reason.name()));
        return this;
    }

    public Continuation build() {
        return new ContinuationImpl(this.proto.build());
    }
}

