/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.continuation.CompiledStatement;
import com.apple.foundationdb.relational.continuation.ContinuationProto;
import com.apple.foundationdb.relational.recordlayer.ContinuationBuilder;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class ContinuationImpl
implements Continuation {
    public static final int CURRENT_VERSION = 1;
    public static final ContinuationImpl BEGIN = new ContinuationImpl((byte[])null);
    public static final ContinuationImpl END = new ContinuationImpl(new byte[0]);
    @Nonnull
    private final ContinuationProto proto;

    private ContinuationImpl(@Nullable byte[] continuationBytes) {
        ContinuationProto.Builder builder = ContinuationProto.newBuilder().setVersion(1);
        if (continuationBytes != null) {
            builder.setExecutionState(ByteString.copyFrom(continuationBytes));
        }
        this.proto = builder.build();
    }

    ContinuationImpl(@Nonnull ContinuationProto proto) {
        this.proto = proto;
    }

    public int getVersion() {
        return this.proto.getVersion();
    }

    @Override
    public byte[] serialize() {
        return this.proto.toByteArray();
    }

    @Override
    @Nullable
    public byte[] getExecutionState() {
        if (!this.proto.hasExecutionState()) {
            return null;
        }
        return this.proto.getExecutionState().toByteArray();
    }

    @Override
    public Continuation.Reason getReason() {
        if (this.proto.hasReason()) {
            return Continuation.Reason.valueOf(this.proto.getReason().name());
        }
        return null;
    }

    public boolean hasCompiledStatement() {
        return this.proto.hasCompiledStatement();
    }

    @Nullable
    public Integer getBindingHash() {
        if (this.proto.hasBindingHash()) {
            return this.proto.getBindingHash();
        }
        return null;
    }

    @Nullable
    public Integer getPlanHash() {
        if (this.proto.hasPlanHash()) {
            return this.proto.getPlanHash();
        }
        return null;
    }

    @Nullable
    public CompiledStatement getCompiledStatement() {
        if (this.proto.hasCompiledStatement()) {
            return this.proto.getCompiledStatement();
        }
        return null;
    }

    public static Continuation fromUnderlyingBytes(@Nullable byte[] bytes) {
        if (bytes == null) {
            return BEGIN;
        }
        if (bytes.length == 0) {
            return END;
        }
        return new ContinuationImpl(bytes);
    }

    public static Continuation fromInt(int offset) {
        assert (offset >= 0);
        return new ContinuationImpl(Ints.toByteArray(offset));
    }

    public static Continuation fromRecordCursorContinuation(RecordCursorContinuation cursorContinuation) {
        return cursorContinuation.isEnd() ? END : new ContinuationImpl(cursorContinuation.toBytes());
    }

    public static ContinuationImpl parseContinuation(byte[] bytes) throws InvalidProtocolBufferException {
        if (bytes == null) {
            return BEGIN;
        }
        return new ContinuationImpl(ContinuationProto.parseFrom(bytes));
    }

    public static ContinuationImpl copyOf(@Nonnull Continuation other) throws RelationalException {
        if (other instanceof ContinuationImpl) {
            return (ContinuationImpl)other;
        }
        if (other.atBeginning()) {
            return BEGIN;
        }
        if (other.atEnd()) {
            return END;
        }
        String message = String.format(Locale.ROOT, "programming error, extra logic required for copy-constructing from %s", other.getClass());
        assert (false) : message;
        throw new RelationalException(message, ErrorCode.INTERNAL_ERROR);
    }

    public static ContinuationBuilder newBuilder() {
        return new ContinuationBuilder();
    }

    public ContinuationBuilder asBuilder() {
        return new ContinuationBuilder(this.proto);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContinuationImpl)) {
            return false;
        }
        ContinuationImpl that = (ContinuationImpl)o;
        return this.proto.equals(that.proto);
    }

    public int hashCode() {
        return Objects.hash(this.proto);
    }
}

