/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metrics.NoOpMetricRegistry;
import com.apple.foundationdb.relational.recordlayer.FdbConnection;
import com.apple.foundationdb.relational.recordlayer.RecordLayerTransactionManager;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.codahale.metrics.MetricRegistry;

@API(value=API.Status.EXPERIMENTAL)
public class DirectFdbConnection
implements FdbConnection {
    private final FDBDatabase fdb;
    private final TransactionManager txnManager;

    public DirectFdbConnection(FDBDatabase fdb) {
        this(fdb, NoOpMetricRegistry.INSTANCE);
    }

    public DirectFdbConnection(FDBDatabase fdb, MetricRegistry metricsEngine) {
        this.fdb = fdb;
        this.txnManager = new RecordLayerTransactionManager(fdb, metricsEngine);
    }

    public static DirectFdbConnection connect(String clusterFile) {
        return new DirectFdbConnection(FDBDatabaseFactory.instance().getDatabase(clusterFile));
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.txnManager;
    }

    @Override
    public void close() throws RelationalException {
        try {
            this.fdb.close();
        }
        catch (RecordCoreException rce) {
            throw ExceptionUtil.toRelationalException(rce);
        }
    }
}

