/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.relational.api.EmbeddedRelationalStruct;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.RelationalDatabaseMetaData;
import com.apple.foundationdb.relational.api.RelationalPreparedStatement;
import com.apple.foundationdb.relational.api.RelationalStatement;
import com.apple.foundationdb.relational.api.RelationalStructBuilder;
import com.apple.foundationdb.relational.api.RowArray;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InternalErrorException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFactory;
import com.apple.foundationdb.relational.api.fluentsql.statement.StatementBuilderFactory;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.api.metrics.MetricCollector;
import com.apple.foundationdb.relational.recordlayer.AbstractDatabase;
import com.apple.foundationdb.relational.recordlayer.CatalogMetaData;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalPreparedStatement;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalStatement;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.metric.RecordLayerMetricCollector;
import com.apple.foundationdb.relational.recordlayer.structuredsql.expression.ExpressionFactoryImpl;
import com.apple.foundationdb.relational.recordlayer.structuredsql.statement.StatementBuilderFactoryImpl;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.apple.foundationdb.relational.util.Supplier;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class EmbeddedRelationalConnection
implements RelationalConnection {
    private static final int DEFAULT_TRANSACTION_LEVEL = 8;
    private boolean isClosed;
    @Nonnull
    private final AbstractDatabase frl;
    @Nonnull
    private final StoreCatalog backingCatalog;
    @Nullable
    private MetricCollector metricCollector;
    @Nullable
    private Transaction transaction;
    ExecuteProperties executeProperties;
    private String currentSchemaLabel;
    private boolean autoCommit = true;
    private final boolean usingAnExternalTransaction;
    private final TransactionManager txnManager;
    @Nonnull
    private Options options;
    private int transactionIsolation;

    @SpotBugsSuppressWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="May be refactored as embedded takes over transaction lifetime")
    public EmbeddedRelationalConnection(@Nonnull AbstractDatabase frl, @Nonnull StoreCatalog backingCatalog, @Nullable Transaction transaction, @Nonnull Options options) throws InternalErrorException {
        this.frl = frl;
        this.txnManager = frl.getTransactionManager();
        this.transaction = transaction;
        boolean bl = this.usingAnExternalTransaction = transaction != null;
        if (this.usingAnExternalTransaction) {
            this.metricCollector = new RecordLayerMetricCollector(transaction.unwrap(RecordContextTransaction.class).getContext());
        }
        this.backingCatalog = backingCatalog;
        this.options = options;
        this.transactionIsolation = 8;
        this.executeProperties = this.newExecuteProperties();
    }

    @Override
    public RelationalStatement createStatement() throws SQLException {
        this.checkOpen();
        return new EmbeddedRelationalStatement(this);
    }

    @Override
    public RelationalPreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new EmbeddedRelationalPreparedStatement(sql, this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (this.usingAnExternalTransaction) {
            throw new RelationalException("Cannot set autoCommit when using an external transaction!", ErrorCode.INVALID_TRANSACTION_STATE).toSqlException();
        }
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (this.inActiveTransaction()) {
            this.commitInternal();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.usingAnExternalTransaction || this.autoCommit;
    }

    boolean canCommit() throws SQLException {
        this.checkOpen();
        return !this.usingAnExternalTransaction && this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new RelationalException("commit called when the Connection is in auto-commit mode!", ErrorCode.CANNOT_COMMIT_ROLLBACK_WITH_AUTOCOMMIT).toSqlException();
        }
        if (!this.inActiveTransaction()) {
            throw new RelationalException("No transaction to commit", ErrorCode.TRANSACTION_INACTIVE).toSqlException();
        }
        this.commitInternal();
    }

    void commitInternal() throws SQLException {
        RelationalException err = null;
        try {
            this.getTransaction().commit();
        }
        catch (RelationalException | RuntimeException re) {
            err = ExceptionUtil.toRelationalException(re);
        }
        try {
            this.getTransaction().close();
        }
        catch (RelationalException | RuntimeException re) {
            if (err != null) {
                err.addSuppressed(ExceptionUtil.toRelationalException(re));
            }
            err = ExceptionUtil.toRelationalException(re);
        }
        this.transaction = null;
        if (err != null) {
            throw err.toSqlException();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new RelationalException("rollback called when the Connection is in auto-commit mode!", ErrorCode.CANNOT_COMMIT_ROLLBACK_WITH_AUTOCOMMIT).toSqlException();
        }
        if (!this.inActiveTransaction()) {
            throw new RelationalException("No transaction to rollback!", ErrorCode.TRANSACTION_INACTIVE).toSqlException();
        }
        this.rollbackInternal();
    }

    void rollbackInternal() throws SQLException {
        RelationalException err = null;
        try {
            this.getTransaction().close();
        }
        catch (RelationalException | RuntimeException re) {
            err = ExceptionUtil.toRelationalException(re);
        }
        this.transaction = null;
        if (err != null) {
            throw err.toSqlException();
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.setSchema(schema, true);
    }

    void setSchema(@Nullable String schema, boolean checkSchemaExists) throws SQLException {
        this.checkOpen();
        if (schema == null) {
            this.currentSchemaLabel = null;
            return;
        }
        if (checkSchemaExists) {
            this.checkSchemaExists(schema);
        }
        this.currentSchemaLabel = schema;
    }

    private void checkSchemaExists(@Nonnull String schema) throws SQLException {
        this.runIsolatedInTransactionIfPossible(() -> {
            if (!this.backingCatalog.doesSchemaExist(this.getTransaction(), this.getRecordLayerDatabase().getURI(), schema)) {
                throw new RelationalException(String.format(Locale.ROOT, "Schema %s does not exist in %s", schema, this.getPath()), ErrorCode.UNDEFINED_SCHEMA);
            }
            return null;
        });
    }

    @Nonnull
    public SchemaTemplate getSchemaTemplate() throws RelationalException {
        try {
            return this.backingCatalog.loadSchema(this.getTransaction(), this.getPath(), this.getSchema()).getSchemaTemplate();
        }
        catch (SQLException sqle) {
            throw new RelationalException(sqle);
        }
    }

    @Nullable
    public MetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.currentSchemaLabel;
    }

    @Override
    public void close() throws SQLException {
        SQLException se = null;
        try {
            if (this.inActiveTransaction()) {
                this.rollbackInternal();
            }
        }
        catch (SQLException e) {
            se = e;
        }
        try {
            this.getRecordLayerDatabase().close();
        }
        catch (RelationalException e) {
            if (se != null) {
                se.addSuppressed(e.toSqlException());
            }
            se = e.toSqlException();
        }
        if (se != null) {
            throw se;
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    @Nonnull
    public RelationalDatabaseMetaData getMetaData() throws SQLException {
        return new CatalogMetaData(this, this.backingCatalog){

            @Override
            public String getDriverName() {
                return "Relational Embedded/Local JDBC Driver";
            }

            @Override
            public int getDefaultTransactionIsolation() {
                return 8;
            }

            @Override
            public boolean supportsTransactionIsolationLevel(int level) {
                return this.getDefaultTransactionIsolation() == level;
            }

            @Override
            public String getCatalogTerm() {
                return "CATALOG";
            }
        };
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        DataType dataType = SqlTypeNamesSupport.getDataTypeFromSqlTypeName(typeName);
        if (dataType != null) {
            return new RowArray(Arrays.stream(elements).collect(Collectors.toList()), RelationalArrayMetaData.of(DataType.ArrayType.from(dataType, false)));
        }
        if (elements.length == 0) {
            throw new RelationalException("Cannot determine the complete component type of array of struct since it has no elements!", ErrorCode.INTERNAL_ERROR).toSqlException();
        }
        DataType elementType = DataType.getDataTypeFromObject(elements[0]);
        if (elementType instanceof DataType.ArrayType) {
            throw new RelationalException("Nested arrays are not supported yet!", ErrorCode.UNSUPPORTED_OPERATION).toSqlException();
        }
        if (elementType.getJdbcSqlCode() != SqlTypeNamesSupport.getSqlTypeCode(typeName)) {
            throw new RelationalException("Element of the array is expected to be of type " + typeName, ErrorCode.DATATYPE_MISMATCH).toSqlException();
        }
        return new RowArray(Arrays.stream(elements).collect(Collectors.toList()), RelationalArrayMetaData.of(DataType.ArrayType.from(elementType, false)));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        RelationalStructBuilder builder = EmbeddedRelationalStruct.newBuilder();
        int nextFieldIndex = 0;
        for (Object atr : attributes) {
            builder.addObject("f" + nextFieldIndex++, atr);
        }
        return builder.build();
    }

    private void startTransaction() throws SQLException {
        try {
            if (!this.inActiveTransaction()) {
                this.transaction = this.txnManager.createTransaction(this.options);
                this.executeProperties = this.newExecuteProperties();
                this.metricCollector = new RecordLayerMetricCollector(this.transaction.unwrap(RecordContextTransaction.class).getContext());
                this.addCloseListener(() -> {
                    if (this.metricCollector != null) {
                        this.metricCollector.flush();
                        this.metricCollector = null;
                    }
                });
            }
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex).toSqlException();
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    @Nonnull
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setOption(Options.Name name, Object value) throws SQLException {
        this.options = this.options.withOption(name, value);
        this.frl.setOption(name, value);
    }

    @Override
    public URI getPath() {
        return this.getRecordLayerDatabase().getURI();
    }

    @Nonnull
    public StoreCatalog getBackingCatalog() {
        return this.backingCatalog;
    }

    @Nonnull
    public Transaction getTransaction() throws RelationalException {
        if (this.transaction == null) {
            throw new RelationalException("No Active Transaction!", ErrorCode.INVALID_TRANSACTION_STATE);
        }
        return this.transaction;
    }

    boolean inActiveTransaction() {
        return this.transaction != null;
    }

    void addCloseListener(@Nonnull Runnable closeListener) throws RelationalException {
        this.transaction.unwrap(RecordContextTransaction.class).addTerminationListener(closeListener);
    }

    @Nonnull
    public AbstractDatabase getRecordLayerDatabase() {
        return this.frl;
    }

    boolean ensureTransactionActive() throws RelationalException, SQLException {
        if (this.inActiveTransaction()) {
            if (this.canCommit()) {
                this.rollbackInternal();
                return this.ensureTransactionActive();
            }
            return false;
        }
        try {
            this.startTransaction();
            return true;
        }
        catch (SQLException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @VisibleForTesting
    public void createNewTransaction() throws RelationalException, SQLException {
        if (this.inActiveTransaction()) {
            throw new RelationalException("There is already an opened transaction!", ErrorCode.INVALID_TRANSACTION_STATE);
        }
        this.ensureTransactionActive();
    }

    @Nonnull
    public ExecuteProperties getExecuteProperties() {
        return this.executeProperties;
    }

    private static IsolationLevel toExecutePropertiesIsolationLevel(int jdbcTransactionIsolation) {
        if (jdbcTransactionIsolation == 8) {
            return IsolationLevel.SERIALIZABLE;
        }
        return IsolationLevel.SNAPSHOT;
    }

    private ExecuteProperties newExecuteProperties() {
        return ExecuteProperties.newBuilder().setIsolationLevel(EmbeddedRelationalConnection.toExecutePropertiesIsolationLevel(this.transactionIsolation)).setTimeLimit((Long)this.options.getOption(Options.Name.EXECUTION_TIME_LIMIT)).setScannedBytesLimit((Long)this.options.getOption(Options.Name.EXECUTION_SCANNED_BYTES_LIMIT)).setScannedRecordsLimit((Integer)this.options.getOption(Options.Name.EXECUTION_SCANNED_ROWS_LIMIT)).setFailOnScanLimitReached(false).build();
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new RelationalException("Connection is closed!", ErrorCode.INTERNAL_ERROR).toSqlException();
        }
    }

    @Override
    @Nonnull
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    @Nonnull
    public StatementBuilderFactory createStatementBuilderFactory() throws SQLException {
        return this.runIsolatedInTransactionIfPossible(() -> new StatementBuilderFactoryImpl(this.getSchemaTemplate(), this));
    }

    @Override
    @Nonnull
    public ExpressionFactory createExpressionBuilderFactory() throws SQLException {
        return this.runIsolatedInTransactionIfPossible(() -> new ExpressionFactoryImpl(this.getSchemaTemplate(), this.getOptions()));
    }

    <T> T runIsolatedInTransactionIfPossible(Supplier<T> operation) throws SQLException {
        boolean newTransaction = false;
        SQLException exception = null;
        T result = null;
        try {
            newTransaction = this.ensureTransactionActive();
            result = operation.get();
        }
        catch (RelationalException e) {
            exception = e.toSqlException();
        }
        if (newTransaction) {
            try {
                this.rollbackInternal();
            }
            catch (SQLException sqle) {
                if (exception != null) {
                    exception.addSuppressed(sqle);
                }
                exception = sqle;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }
}

