/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalPreparedStatement;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractEmbeddedStatement;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.query.PreparedParams;
import com.apple.foundationdb.relational.util.Assert;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class EmbeddedRelationalPreparedStatement
extends AbstractEmbeddedStatement
implements RelationalPreparedStatement {
    @Nonnull
    private final String sql;
    @Nonnull
    private final Map<Integer, Object> parameters = new TreeMap<Integer, Object>();
    @Nonnull
    private final Map<String, Object> namedParameters = new TreeMap<String, Object>();

    public EmbeddedRelationalPreparedStatement(@Nonnull String sql, @Nonnull EmbeddedRelationalConnection conn) throws SQLException {
        super(conn);
        this.sql = sql;
    }

    @Override
    public RelationalResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.execute()) {
            return this.currentResultSet;
        }
        throw new SQLException(String.format(Locale.ROOT, "query '%s' does not return result set, use JDBC executeUpdate method instead", this.sql), ErrorCode.NO_RESULT_SET.getErrorCode());
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.execute()) {
            throw new SQLException(String.format(Locale.ROOT, "query '%s' returns a result set, use JDBC executeQuery method instead", this.sql), ErrorCode.EXECUTE_UPDATE_RETURNED_RESULT_SET.getErrorCode());
        }
        return this.currentRowCount;
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            return this.executeInternal(this.sql);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setArray(String parameterName, Array x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setUUID(int parameterIndex, UUID x) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public void setUUID(String parameterName, UUID x) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        this.parameters.put(parameterIndex, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.checkOpen();
        this.namedParameters.put(parameterName, null);
    }

    @Override
    @Nonnull
    PlanContext createPlanContext(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Options options) throws RelationalException {
        return PlanContext.builder().fromRecordStore(store, options).fromDatabase(this.conn.getRecordLayerDatabase()).withMetricsCollector(Assert.notNullUnchecked(this.conn.getMetricCollector())).withPreparedParameters(PreparedParams.of(this.parameters, this.namedParameters)).withSchemaTemplate(this.conn.getTransaction().getBoundSchemaTemplateMaybe().orElse(this.conn.getSchemaTemplate())).build();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

