/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.KeySet;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStatement;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractEmbeddedStatement;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.DirectScannable;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.ErrorCapturingResultSet;
import com.apple.foundationdb.relational.recordlayer.Index;
import com.apple.foundationdb.relational.recordlayer.IteratorResultSet;
import com.apple.foundationdb.relational.recordlayer.KeyBuilder;
import com.apple.foundationdb.relational.recordlayer.RecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.ResumableIterator;
import com.apple.foundationdb.relational.recordlayer.Table;
import com.apple.foundationdb.relational.recordlayer.query.PlanContext;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.Supplier;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class EmbeddedRelationalStatement
extends AbstractEmbeddedStatement
implements RelationalStatement {
    public EmbeddedRelationalStatement(@Nonnull EmbeddedRelationalConnection conn) throws SQLException {
        super(conn);
    }

    @Override
    @Nonnull
    PlanContext createPlanContext(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Options options) throws RelationalException {
        return PlanContext.builder().fromRecordStore(store, options).fromDatabase(this.conn.getRecordLayerDatabase()).withMetricsCollector(Assert.notNullUnchecked(this.conn.getMetricCollector())).withSchemaTemplate(this.conn.getTransaction().getBoundSchemaTemplateMaybe().orElse(this.conn.getSchemaTemplate())).build();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.executeInternal(sql);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public RelationalResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.getResultSet();
        }
        throw new SQLException(String.format(Locale.ROOT, "query '%s' does not return result set, use JDBC executeUpdate method instead", sql), ErrorCode.NO_RESULT_SET.getErrorCode());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        if (this.execute(sql)) {
            throw new SQLException(String.format(Locale.ROOT, "query '%s' returns a result set, use JDBC executeQuery method instead", sql), ErrorCode.EXECUTE_UPDATE_RETURNED_RESULT_SET.getErrorCode());
        }
        return this.currentRowCount;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.currentResultSet != null) {
            return -1;
        }
        return this.currentRowCount;
    }

    @Override
    @Nonnull
    public RelationalResultSet executeScan(@Nonnull String tableName, @Nonnull KeySet prefix, @Nonnull Options options) throws SQLException {
        this.checkOpen();
        Options finalOptions = this.options.withChild(options);
        try {
            this.conn.ensureTransactionActive();
            String[] schemaAndTable = this.getSchemaAndTable(this.conn, tableName);
            RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(schemaAndTable[0]);
            Table table = schema.loadTable(schemaAndTable[1]);
            String indexName = (String)finalOptions.getOption(Options.Name.INDEX_HINT);
            this.validateBindingHash((ContinuationImpl)options.getOption(Options.Name.CONTINUATION));
            DirectScannable source = this.getSourceScannable(indexName, table);
            KeyBuilder keyBuilder = source.getKeyBuilder();
            Row row = keyBuilder.buildKey(prefix.toMap(), false);
            StructMetaData sourceMetaData = source.getMetaData();
            return new ErrorCapturingResultSet(new RecordLayerResultSet(sourceMetaData, source.openScan(row, finalOptions), this.conn));
        }
        catch (RelationalException ve) {
            throw ve.toSqlException();
        }
    }

    @Override
    @Nonnull
    public RelationalResultSet executeGet(@Nonnull String tableName, @Nonnull KeySet key, @Nonnull Options options) throws SQLException {
        this.checkOpen();
        Options finalizedOptions = this.options.withChild(options);
        return this.ensureTransaction(() -> {
            String[] schemaAndTable = this.getSchemaAndTable(this.conn, tableName);
            RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(schemaAndTable[0]);
            Table table = schema.loadTable(schemaAndTable[1]);
            String indexName = (String)finalizedOptions.getOption(Options.Name.INDEX_HINT);
            this.validateBindingHash((ContinuationImpl)options.getOption(Options.Name.CONTINUATION));
            DirectScannable source = this.getSourceScannable(indexName, table);
            source.validate(finalizedOptions);
            Row tuple = source.getKeyBuilder().buildKey(key.toMap(), true);
            Row row = source.get(this.conn.getTransaction(), tuple, finalizedOptions);
            Iterator rowIter = row == null ? Collections.emptyIterator() : Collections.singleton(row).iterator();
            return new ErrorCapturingResultSet(new IteratorResultSet(table.getMetaData(), rowIter, 0));
        });
    }

    @Override
    public int executeInsert(@Nonnull String tableName, @Nonnull List<RelationalStruct> data, @Nonnull Options options) throws SQLException {
        this.checkOpen();
        Options finalizedOptions = this.options.withChild(options);
        if (data.isEmpty()) {
            return 0;
        }
        return this.ensureTransaction(() -> {
            String[] schemaAndTable = this.getSchemaAndTable(this.conn, tableName);
            RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(schemaAndTable[0]);
            Table table = schema.loadTable(schemaAndTable[1]);
            table.validateTable(finalizedOptions);
            Boolean replaceOnDuplicate = (Boolean)finalizedOptions.getOption(Options.Name.REPLACE_ON_DUPLICATE_PK);
            this.validateBindingHash((ContinuationImpl)options.getOption(Options.Name.CONTINUATION));
            int rowCount = 0;
            for (RelationalStruct struct : data) {
                if (!table.insertRecord(struct, replaceOnDuplicate != null && replaceOnDuplicate != false)) continue;
                ++rowCount;
            }
            this.currentRowCount = rowCount;
            return this.currentRowCount;
        });
    }

    @Override
    public int executeDelete(@Nonnull String tableName, @Nonnull Iterator<KeySet> keys, @Nonnull Options options) throws SQLException {
        this.checkOpen();
        if (!keys.hasNext()) {
            return 0;
        }
        Options finalizedOptions = this.options.withChild(options);
        return this.ensureTransaction(() -> {
            String[] schemaAndTable = this.getSchemaAndTable(this.conn, tableName);
            RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(schemaAndTable[0]);
            Table table = schema.loadTable(schemaAndTable[1]);
            table.validateTable(finalizedOptions);
            this.validateBindingHash((ContinuationImpl)options.getOption(Options.Name.CONTINUATION));
            int count = 0;
            Row toDelete = table.getKeyBuilder().buildKey(((KeySet)keys.next()).toMap(), true);
            while (toDelete != null) {
                if (table.deleteRecord(toDelete)) {
                    ++count;
                }
                toDelete = null;
                if (!keys.hasNext()) continue;
                toDelete = table.getKeyBuilder().buildKey(((KeySet)keys.next()).toMap(), true);
            }
            return count;
        });
    }

    @Override
    public void executeDeleteRange(@Nonnull String tableName, @Nonnull KeySet prefix, @Nonnull Options options) throws SQLException {
        this.checkOpen();
        Options finalizedOptions = this.options.withChild(options);
        this.ensureTransaction(() -> {
            String[] schemaAndTable = this.getSchemaAndTable(this.conn, tableName);
            RecordLayerSchema schema = this.conn.getRecordLayerDatabase().loadSchema(schemaAndTable[0]);
            Table table = schema.loadTable(schemaAndTable[1]);
            table.validateTable(finalizedOptions);
            this.validateBindingHash((ContinuationImpl)options.getOption(Options.Name.CONTINUATION));
            Map<String, Object> deletePrefixColumns = prefix.toMap();
            KeyBuilder keyBuilder = table.getKeyBuilder();
            Row row = keyBuilder.buildKey(deletePrefixColumns, false);
            int keyLength = row.getNumFields();
            if (row.getNumFields() == keyBuilder.getKeySize() && row.getObject(keyLength - 1) != null) {
                table.deleteRecord(row);
                return null;
            }
            try {
                table.deleteRange(deletePrefixColumns);
            }
            catch (Query.InvalidExpressionException ex) {
                Continuation continuation = ContinuationImpl.BEGIN;
                try {
                    ResumableIterator<Row> scannedRows;
                    do {
                        Options newOptions = finalizedOptions.withChild(Options.builder().withOption(Options.Name.CONTINUATION, continuation).build());
                        scannedRows = table.openScan(row, newOptions);
                        while (scannedRows.hasNext()) {
                            Row scannedRow = (Row)scannedRows.next();
                            if (table.deleteRecord(keyBuilder.buildKey(scannedRow))) continue;
                            throw new RelationalException("Cannot delete record during fallback deleteRange", ErrorCode.INTERNAL_ERROR);
                        }
                        continuation = scannedRows.getContinuation();
                    } while (scannedRows.terminatedEarly());
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
            return null;
        });
    }

    private void validateBindingHash(@Nullable ContinuationImpl continuation) throws RelationalException {
        if (continuation != null && continuation.getBindingHash() != null) {
            throw new RelationalException("Continuation doesn't match direct access APIs.", ErrorCode.INVALID_CONTINUATION);
        }
    }

    private String[] getSchemaAndTable(@Nonnull EmbeddedRelationalConnection connection, @Nonnull String tableName) throws RelationalException {
        try {
            String schema = connection.getSchema();
            String tableN = tableName;
            if (tableName.contains(".")) {
                String[] t2 = tableName.split("\\.");
                schema = t2[0];
                tableN = t2[1];
            }
            if (schema == null) {
                throw new RelationalException("Invalid table format", ErrorCode.INVALID_PARAMETER);
            }
            return new String[]{schema, tableN};
        }
        catch (SQLException sqle) {
            throw new RelationalException(sqle);
        }
    }

    @Nonnull
    private DirectScannable getSourceScannable(String indexName, @Nonnull Table table) throws RelationalException {
        if (indexName != null) {
            Index index = null;
            Set<Index> readableIndexes = table.getAvailableIndexes();
            for (Index idx : readableIndexes) {
                if (!idx.getName().equals(indexName)) continue;
                index = idx;
                break;
            }
            if (index == null) {
                throw new RelationalException("Unknown index: <" + indexName + "> on type <" + table.getName() + ">", ErrorCode.UNDEFINED_INDEX);
            }
            return index;
        }
        return table;
    }

    private <T> T ensureTransaction(Supplier<T> operation) throws SQLException {
        boolean newTransaction = false;
        SQLException exception = null;
        T result = null;
        try {
            newTransaction = this.conn.ensureTransactionActive();
            result = operation.get();
        }
        catch (RelationalException e) {
            exception = e.toSqlException();
        }
        catch (RuntimeException e) {
            exception = ExceptionUtil.toRelationalException(e).toSqlException();
        }
        if (newTransaction) {
            if (exception != null) {
                try {
                    this.conn.rollbackInternal();
                }
                catch (SQLException sqle) {
                    exception.addSuppressed(sqle);
                }
            } else if (this.conn.canCommit()) {
                this.conn.commitInternal();
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }
}

