/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalResultSetMetaData;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ErrorCapturingResultSet
implements RelationalResultSet {
    private final RelationalResultSet delegate;

    public ErrorCapturingResultSet(RelationalResultSet delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.delegate.next();
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.delegate.close();
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.delegate.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this.delegate.getString(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.delegate.getBoolean(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.delegate.getInt(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.delegate.getLong(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.delegate.getFloat(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.delegate.getDouble(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this.delegate.getBytes(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            return this.delegate.getString(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return this.delegate.getBoolean(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            return this.delegate.getInt(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            return this.delegate.getLong(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            return this.delegate.getFloat(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            return this.delegate.getDouble(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            return this.delegate.getBytes(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public RelationalResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.delegate.getMetaData();
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.delegate.getObject(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            return this.delegate.getObject(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public RelationalArray getArray(int columnIndex) throws SQLException {
        try {
            return this.delegate.getArray(columnIndex);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public RelationalArray getArray(String columnLabel) throws SQLException {
        try {
            return this.delegate.getArray(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public UUID getUUID(int oneBasedPosition) throws SQLException {
        try {
            return this.delegate.getUUID(oneBasedPosition);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public UUID getUUID(String fieldName) throws SQLException {
        try {
            return this.delegate.getUUID(fieldName);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    @Nonnull
    public Continuation getContinuation() throws SQLException {
        try {
            return this.delegate.getContinuation();
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public RelationalStruct getStruct(String columnLabel) throws SQLException {
        try {
            return this.delegate.getStruct(columnLabel);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }

    @Override
    public RelationalStruct getStruct(int oneBasedColumn) throws SQLException {
        try {
            return this.delegate.getStruct(oneBasedColumn);
        }
        catch (RuntimeException re) {
            throw ExceptionUtil.toRelationalException(re).toSqlException();
        }
    }
}

