/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.api.exceptions.InvalidTypeException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractRow;
import com.apple.foundationdb.relational.recordlayer.ValueTuple;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class FDBTuple
extends AbstractRow {
    private Tuple tuple;

    public FDBTuple(Tuple tuple) {
        this.tuple = tuple;
    }

    void setTuple(Tuple t2) {
        this.tuple = t2;
    }

    @Override
    public int getNumFields() {
        return this.tuple.size();
    }

    @Override
    public Object getObject(int position) throws InvalidColumnReferenceException {
        if (position < 0 || position >= this.tuple.size()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        return this.tuple.get(position);
    }

    @Override
    public Row getRow(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.tuple.size()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        try {
            return new FDBTuple(this.tuple.getNestedTuple(position));
        }
        catch (ClassCastException cce) {
            throw new InvalidTypeException("Object <" + String.valueOf(this.tuple.get(position)) + "> cannot be converted to a Tuple type", (Throwable)cce);
        }
    }

    @Override
    public Iterable<Row> getArray(int position) throws InvalidTypeException, InvalidColumnReferenceException {
        if (position < 0 || position >= this.tuple.size()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        try {
            List<Object> nestedList = this.tuple.getNestedList(position);
            return nestedList.stream().map(obj -> {
                if (obj instanceof Tuple) {
                    return new FDBTuple((Tuple)obj);
                }
                return new ValueTuple(obj);
            }).collect(Collectors.toList());
        }
        catch (ClassCastException cce) {
            throw new InvalidTypeException("Object <" + String.valueOf(this.tuple.get(position)) + "> cannot be converted to an iterable type", (Throwable)cce);
        }
    }

    Tuple fdbTuple() {
        return this.tuple;
    }

    @Override
    public String toString() {
        return this.tuple.toString();
    }

    @Nonnull
    public static FDBTuple fromRow(@Nonnull Row copy) throws RelationalException {
        ArrayList<Object> items = new ArrayList<Object>(copy.getNumFields());
        for (int i = 0; i < copy.getNumFields(); ++i) {
            items.add(copy.getObject(i));
        }
        Tuple t2 = Tuple.fromList(items);
        return new FDBTuple(t2);
    }
}

