/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.recordlayer.AbstractRow;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImmutableKeyValue
extends AbstractRow {
    private final Row key;
    private final Row value;

    public ImmutableKeyValue(@Nonnull Row key, @Nonnull Row value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getNumFields() {
        return this.key.getNumFields() + this.value.getNumFields();
    }

    @Override
    public Object getObject(int position) throws InvalidColumnReferenceException {
        if (position < this.key.getNumFields()) {
            return this.key.getObject(position);
        }
        return this.value.getObject(position - this.key.getNumFields());
    }
}

