/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractRecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import java.sql.SQLException;
import java.util.Iterator;
import javax.annotation.Nonnull;

@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentionally exposed for performance reasons")
@API(value=API.Status.EXPERIMENTAL)
public class IteratorResultSet
extends AbstractRecordLayerResultSet {
    private final Iterator<? extends Row> rowIter;
    private int currentRowPosition;

    public IteratorResultSet(StructMetaData metaData, Iterator<? extends Row> rowIter, int initialRowPosition) {
        super(metaData);
        this.rowIter = rowIter;
        this.currentRowPosition = initialRowPosition;
    }

    @Override
    @Nonnull
    public Continuation getContinuation() throws SQLException {
        boolean beginning;
        boolean hasNext = this.rowIter.hasNext();
        boolean bl = beginning = this.currentRowPosition == 0;
        if (hasNext) {
            throw new SQLException("Continuation can only be returned once the result set has been exhausted", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        if (beginning) {
            return ContinuationImpl.BEGIN;
        }
        return ContinuationImpl.END;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    protected boolean hasNext() {
        return this.rowIter.hasNext();
    }

    @Override
    protected Row advanceRow() throws RelationalException {
        if (!this.rowIter.hasNext()) {
            return null;
        }
        ++this.currentRowPosition;
        return this.rowIter.next();
    }
}

