/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.FDBTuple;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class KeyBuilder {
    private final RecordType typeForKey;
    private final KeyExpression key;
    private final String scannableNameForMessage;

    public KeyBuilder(RecordType typeForKey, KeyExpression key, String scannableName) {
        this.key = key;
        this.typeForKey = typeForKey;
        this.scannableNameForMessage = scannableName;
    }

    public int getKeySize() {
        return this.key.getColumnSize();
    }

    @Nonnull
    public Row buildKey(Map<String, Object> keyFields, boolean failOnIncompleteKey) throws RelationalException {
        HashMap<String, Object> keysNotPicked = new HashMap<String, Object>(keyFields);
        ArrayList<Object> flattenedFields = new ArrayList<Object>();
        for (Object key : this.flattenKeys()) {
            if (key instanceof RecordType) {
                flattenedFields.add(((RecordType)key).getRecordTypeKey());
                continue;
            }
            if (key instanceof String) {
                Object value = keyFields.get(key);
                if (value != null) {
                    keysNotPicked.remove(key);
                }
                flattenedFields.add(value);
                continue;
            }
            Assert.fail("Should never happen");
        }
        if (failOnIncompleteKey && flattenedFields.stream().anyMatch(Objects::isNull)) {
            int missing = IntStream.range(0, flattenedFields.size()).filter(i -> flattenedFields.get(i) == null).findFirst().getAsInt();
            throw new RelationalException("Cannot form incomplete key: missing key at position <" + missing + ">", ErrorCode.INVALID_PARAMETER);
        }
        if (!keysNotPicked.isEmpty()) {
            throw new RelationalException("Unknown keys for " + this.scannableNameForMessage + ", unknown keys: <" + Joiner.on(",").join(keysNotPicked.keySet()) + ">", ErrorCode.INVALID_PARAMETER);
        }
        while (!flattenedFields.isEmpty() && flattenedFields.get(flattenedFields.size() - 1) == null) {
            flattenedFields.remove(flattenedFields.size() - 1);
        }
        if (flattenedFields.stream().anyMatch(Objects::isNull)) {
            int missing = IntStream.range(0, flattenedFields.size()).filter(i -> flattenedFields.get(i) == null).findFirst().getAsInt();
            throw new RelationalException("Cannot form key: missing key at position <" + missing + ">", ErrorCode.INVALID_PARAMETER);
        }
        return new FDBTuple(Tuple.fromList(flattenedFields));
    }

    @Nonnull
    public Row buildKey(Row scannedRow) throws RelationalException {
        int scannedIndex = 0;
        ArrayList<Object> flattenedFields = new ArrayList<Object>();
        for (Object key : this.flattenKeys()) {
            if (key instanceof RecordType) {
                flattenedFields.add(((RecordType)key).getRecordTypeKey());
                continue;
            }
            flattenedFields.add(scannedRow.getObject(scannedIndex++));
        }
        return new FDBTuple(Tuple.fromList(flattenedFields));
    }

    private List<Object> flattenKeys() throws RelationalException {
        ArrayList<Object> keys = new ArrayList<Object>();
        Stack<KeyExpression> nextExpressions = new Stack<KeyExpression>();
        nextExpressions.push(this.key);
        while (!nextExpressions.isEmpty()) {
            List<KeyExpression> children;
            KeyExpression expr = (KeyExpression)nextExpressions.pop();
            if (expr instanceof FieldKeyExpression) {
                keys.add(((FieldKeyExpression)expr).getFieldName());
                continue;
            }
            if (expr instanceof ThenKeyExpression) {
                children = ((ThenKeyExpression)expr).getChildren();
                for (int i = children.size() - 1; i >= 0; --i) {
                    nextExpressions.push(children.get(i));
                }
                continue;
            }
            if (expr instanceof KeyWithValueExpression || expr instanceof GroupingKeyExpression || expr instanceof NestingKeyExpression) {
                children = expr.normalizeKeyForPositions();
                int size = expr instanceof KeyWithValueExpression ? ((KeyWithValueExpression)expr).getSplitPoint() : children.size();
                for (int i = size - 1; i >= 0; --i) {
                    nextExpressions.push(children.get(i));
                }
                continue;
            }
            if (!(expr instanceof RecordTypeKeyExpression)) continue;
            try {
                keys.add(this.typeForKey);
            }
            catch (RecordCoreException ex) {
                throw ExceptionUtil.toRelationalException(ex);
            }
        }
        return keys;
    }
}

