/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.DirectoryLayerDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceDirectory;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.NoSuchDirectoryException;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.OperationUnsupportedException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class KeySpaceUtils {
    @Nonnull
    public static URI pathToUri(@Nonnull KeySpacePath dbPath) {
        return URI.create("/" + KeySpaceUtils.toPathString(dbPath));
    }

    public static String toPathString(KeySpacePath path) {
        Object uriPath = "";
        while (path != null) {
            uriPath = path.getDirectory().getKeyType() == KeySpaceDirectory.KeyType.NULL ? "/" + (String)uriPath : (((String)uriPath).length() > 0 ? path.getValue().toString() + "/" + (String)uriPath : path.getValue().toString());
            path = path.getParent();
        }
        return uriPath;
    }

    @Nonnull
    @VisibleForTesting
    public static KeySpacePath toKeySpacePath(@Nonnull URI url, KeySpace keySpace) throws RelationalException {
        KeySpaceDirectory sub;
        Object path = KeySpaceUtils.getPath(url);
        if (((String)path).length() < 1) {
            throw new RelationalException("<" + String.valueOf(url) + "> is an invalid database path", ErrorCode.INVALID_PATH);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        String[] pathElems = ((String)path).split("/");
        if (((String)path).endsWith("/")) {
            pathElems = Arrays.copyOf(pathElems, pathElems.length + 1);
            pathElems[pathElems.length - 1] = "";
        }
        if (pathElems.length == 2 && "__SYS".equals(pathElems[1])) {
            return keySpace.path("__SYS").add("__SYS");
        }
        KeySpaceDirectory directory = keySpace.getRoot();
        KeySpacePath thePath = null;
        Iterator<KeySpaceDirectory> iterator = directory.getSubdirectories().iterator();
        while (iterator.hasNext() && (thePath = KeySpaceUtils.uriToPathRecursive(keySpace, sub = iterator.next(), keySpace.path(sub.getName()), pathElems, 1)) == null) {
        }
        if (thePath == null) {
            throw new RelationalException("<" + String.valueOf(url) + "> is an invalid database path", ErrorCode.INVALID_PATH);
        }
        return thePath;
    }

    public static String getPath(@Nonnull URI url) {
        String authority = url.getAuthority();
        return authority != null && authority.length() > 0 ? "//" + authority + url.getPath() : url.getPath();
    }

    @Nullable
    private static KeySpacePath uriToPathRecursive(@Nonnull KeySpace keySpace, @Nonnull KeySpaceDirectory directory, KeySpacePath parentPath, @Nonnull String[] pathElems, int position) throws OperationUnsupportedException {
        if (position >= pathElems.length) {
            return parentPath;
        }
        String pathElem = pathElems[position];
        String pathName = directory.getName();
        Object dirVal = directory.getValue();
        Object pathValue = null;
        switch (directory.getKeyType()) {
            case NULL: {
                if (pathElem.isEmpty()) break;
                return null;
            }
            case STRING: {
                pathValue = pathElem;
                if (pathElem.isEmpty()) {
                    return null;
                }
                if (Objects.equals(dirVal, KeySpaceDirectory.ANY_VALUE) || Objects.equals(dirVal, pathElem)) break;
                return null;
            }
            case LONG: {
                if (directory instanceof DirectoryLayerDirectory) {
                    pathValue = pathElem;
                } else {
                    try {
                        long l = Long.parseLong(pathElem);
                        pathValue = l;
                        if (Objects.equals(dirVal, KeySpaceDirectory.ANY_VALUE)) break;
                        if (!Objects.equals(dirVal, l)) {
                            return null;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
                if (Objects.equals(dirVal, KeySpaceDirectory.ANY_VALUE) || Objects.equals(dirVal, pathValue)) break;
                return null;
            }
            default: {
                throw new OperationUnsupportedException("Key Space paths only supported for NULL, LONG and STRING");
            }
        }
        try {
            parentPath = directory.getParent() == keySpace.getRoot() ? keySpace.path(pathName, pathValue) : parentPath.add(pathName, pathValue);
        }
        catch (NoSuchDirectoryException nsde) {
            return null;
        }
        if (directory.isLeaf()) {
            return parentPath;
        }
        for (KeySpaceDirectory dir : directory.getSubdirectories()) {
            KeySpacePath childPath = KeySpaceUtils.uriToPathRecursive(keySpace, dir, parentPath, pathElems, position + 1);
            if (childPath == null) continue;
            return childPath;
        }
        return null;
    }

    private KeySpaceUtils() {
    }
}

