/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.recordlayer.AbstractRow;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.stream.Collectors;

@API(value=API.Status.EXPERIMENTAL)
public class MessageTuple
extends AbstractRow {
    private final Message message;

    public MessageTuple(Message m4) {
        this.message = m4;
    }

    @Override
    public int getNumFields() {
        return this.message.getDescriptorForType().getFields().size();
    }

    @Override
    public Object getObject(int position) throws InvalidColumnReferenceException {
        if (position < 0 || position >= this.getNumFields()) {
            throw InvalidColumnReferenceException.getExceptionForInvalidPositionNumber(position);
        }
        Descriptors.FieldDescriptor fieldDescriptor = this.message.getDescriptorForType().getFields().get(position);
        if (fieldDescriptor.isRepeated()) {
            List list = (List)this.message.getField(this.message.getDescriptorForType().getFields().get(position));
            return list.stream().map(MessageTuple::sanitizeField).collect(Collectors.toList());
        }
        if (this.message.hasField(fieldDescriptor)) {
            Object field = this.message.getField(this.message.getDescriptorForType().getFields().get(position));
            return MessageTuple.sanitizeField(field);
        }
        return null;
    }

    public static Object sanitizeField(Object field) {
        if (field instanceof Message && ((Message)field).getDescriptorForType().equals(TupleFieldsProto.UUID.getDescriptor())) {
            return TupleFieldsHelper.fromProto((Message)field, TupleFieldsProto.UUID.getDescriptor());
        }
        if (field instanceof Descriptors.EnumValueDescriptor) {
            return ((Descriptors.EnumValueDescriptor)field).getName();
        }
        if (field instanceof ByteString) {
            return ((ByteString)field).toByteArray();
        }
        return field;
    }

    public <M extends Message> M parseMessage() {
        return (M)this.message;
    }

    @Override
    public String toString() {
        return "(" + this.message.toString() + ")";
    }
}

