/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.recordlayer.RecordLayerIterator;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.ResumableIterator;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.google.protobuf.Message;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QueryExecutor {
    private final RecordLayerSchema schema;
    private final RecordQueryPlan plan;
    private final EvaluationContext evaluationContext;

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="internal implementation should have proper usage")
    public QueryExecutor(@Nonnull RecordQueryPlan plan, @Nonnull EvaluationContext evaluationContext, @Nonnull RecordLayerSchema schema) {
        this.schema = schema;
        this.evaluationContext = evaluationContext;
        this.plan = plan;
    }

    @Nonnull
    public ResumableIterator<Row> execute(@Nullable Continuation continuation, @Nonnull ExecuteProperties executeProperties) throws RelationalException {
        FDBRecordStoreBase fdbRecordStore = Assert.notNull(this.schema.loadStore()).unwrap(FDBRecordStoreBase.class);
        RecordCursor<QueryResult> cursor = this.plan.executePlan(fdbRecordStore, this.evaluationContext, continuation == null ? null : continuation.getExecutionState(), executeProperties);
        return RecordLayerIterator.create(cursor, messageFDBQueriedRecord -> new MessageTuple((Message)messageFDBQueriedRecord.getMessage()));
    }

    public Type getQueryResultType() {
        return this.plan.getResultType().getInnerType();
    }
}

