/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.relational.api.ConnectionScoped;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InternalErrorException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@ConnectionScoped
@API(value=API.Status.EXPERIMENTAL)
public class RecordContextTransaction
implements Transaction {
    private final List<Runnable> txnTerminateListeners = new LinkedList<Runnable>();
    private final FDBRecordContext context;
    private boolean isClosed;

    public RecordContextTransaction(FDBRecordContext context) {
        this.context = context;
    }

    @Override
    public void commit() throws RelationalException {
        try {
            this.context.commit();
        }
        catch (FDBExceptions.FDBStoreTransactionConflictException ex) {
            throw new RelationalException(ex.getMessage(), ErrorCode.SERIALIZATION_FAILURE, ex);
        }
        catch (RecordCoreException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
        this.notifyTerminated();
    }

    @Override
    public void abort() throws RelationalException {
        this.isClosed = true;
        this.notifyTerminated();
        try {
            this.context.close();
        }
        catch (RecordCoreException e) {
            throw ExceptionUtil.toRelationalException(e);
        }
    }

    @Override
    @Nonnull
    public Optional<SchemaTemplate> getBoundSchemaTemplateMaybe() {
        return Optional.ofNullable(this.context.getInSession(SchemaTemplate.class.toString(), SchemaTemplate.class));
    }

    @Override
    public void setBoundSchemaTemplate(@Nonnull SchemaTemplate schemaTemplate) {
        this.unsetBoundSchemaTemplate();
        this.context.putInSessionIfAbsent(SchemaTemplate.class.toString(), schemaTemplate);
    }

    @Override
    public void unsetBoundSchemaTemplate() {
        this.context.removeFromSession(SchemaTemplate.class.toString(), SchemaTemplate.class);
    }

    @Override
    public void close() throws RelationalException {
        this.abort();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    @Nonnull
    public <T> T unwrap(@Nonnull Class<? extends T> type) throws InternalErrorException {
        if (FDBRecordContext.class.isAssignableFrom(type)) {
            return type.cast(this.context);
        }
        return Transaction.super.unwrap(type);
    }

    private void notifyTerminated() {
        for (Runnable callable : this.txnTerminateListeners) {
            callable.run();
        }
    }

    public void addTerminationListener(@Nonnull Runnable onTerminateListener) {
        assert (!this.isClosed) : "Cannot add a termination listener to a closed transaction!";
        this.txnTerminateListeners.add(onTerminateListener);
    }

    public FDBRecordContext getContext() {
        return this.context;
    }
}

