/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerConfig {
    private final FDBRecordStoreBase.UserVersionChecker userVersionChecker;
    private final FormatVersion formatVersion;
    private final Map<String, IndexState> indexStateMap;

    private RecordLayerConfig(RecordLayerConfigBuilder builder) {
        this.userVersionChecker = builder.userVersionChecker;
        this.formatVersion = builder.formatVersion;
        this.indexStateMap = builder.indexStateMap;
    }

    public FDBRecordStoreBase.UserVersionChecker getUserVersionChecker() {
        return this.userVersionChecker;
    }

    public FormatVersion getFormatVersion() {
        return this.formatVersion;
    }

    public Map<String, IndexState> getIndexStateMap() {
        return this.indexStateMap;
    }

    public static RecordLayerConfig getDefault() {
        return new RecordLayerConfigBuilder().build();
    }

    public static class RecordLayerConfigBuilder {
        private FDBRecordStoreBase.UserVersionChecker userVersionChecker = (oldUserVersion, oldMetaDataVersion, metaData) -> CompletableFuture.completedFuture(oldUserVersion);
        private FormatVersion formatVersion = FormatVersion.getDefaultFormatVersion();
        private Map<String, IndexState> indexStateMap = Map.of();

        public RecordLayerConfigBuilder setIndexStateMap(Map<String, IndexState> indexStateMap) {
            this.indexStateMap = indexStateMap;
            return this;
        }

        @Deprecated(forRemoval=true)
        public RecordLayerConfigBuilder setFormatVersion(int formatVersion) {
            this.formatVersion = FormatVersion.getFormatVersion(formatVersion);
            return this;
        }

        public RecordLayerConfigBuilder setFormatVersion(FormatVersion formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public RecordLayerConfigBuilder setUserVersionChecker(FDBRecordStoreBase.UserVersionChecker userVersionChecker) {
            this.userVersionChecker = userVersionChecker;
            return this;
        }

        public RecordLayerConfig build() {
            return new RecordLayerConfig(this);
        }
    }
}

