/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.api.ddl.MetadataOperationsFactory;
import com.apple.foundationdb.relational.api.exceptions.InvalidTypeException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractDatabase;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.FdbConnection;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.CachedMetaDataStore;
import com.apple.foundationdb.relational.recordlayer.catalog.RecordMetaDataStore;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.recordlayer.storage.BackingRecordStore;
import com.apple.foundationdb.relational.recordlayer.storage.StoreConfig;
import java.net.URI;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerDatabase
extends AbstractDatabase {
    private final FdbConnection fdbDb;
    private final RecordMetaDataStore metaDataStore;
    private final StoreCatalog storeCatalog;
    private final RecordLayerConfig recordLayerConfig;
    private final RelationalKeyspaceProvider.RelationalDatabasePath databasePath;
    @Nullable
    private final String defaultSchema;

    public RecordLayerDatabase(FdbConnection fdbDb, RecordMetaDataStore metaDataStore, StoreCatalog storeCatalog, RecordLayerConfig config, RelationalKeyspaceProvider.RelationalDatabasePath databasePath, @Nonnull MetadataOperationsFactory metadataOperationsFactory, @Nonnull DdlQueryFactory ddlQueryFactory, @Nullable RelationalPlanCache planCache, @Nullable String defaultSchema, @Nonnull Options options) {
        super(metadataOperationsFactory, ddlQueryFactory, planCache, options);
        this.fdbDb = fdbDb;
        this.metaDataStore = new CachedMetaDataStore(metaDataStore);
        this.storeCatalog = storeCatalog;
        this.recordLayerConfig = config;
        this.databasePath = databasePath;
        this.defaultSchema = defaultSchema;
    }

    @Override
    public RelationalConnection connect(@Nullable Transaction transaction) throws RelationalException {
        if (transaction != null && !(transaction instanceof RecordContextTransaction)) {
            throw new InvalidTypeException("Invalid Transaction type to use to connect to FDB");
        }
        EmbeddedRelationalConnection conn = new EmbeddedRelationalConnection(this, this.storeCatalog, transaction, this.options);
        this.setConnection(conn);
        if (this.defaultSchema != null) {
            try {
                conn.setSchema(this.defaultSchema, false);
            }
            catch (SQLException e) {
                throw new RelationalException(e);
            }
        }
        return conn;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.getFDBDatabase().getTransactionManager();
    }

    @Override
    public void close() throws RelationalException {
        for (RecordLayerSchema schema : this.schemas.values()) {
            schema.close();
        }
        this.schemas.clear();
    }

    BackingRecordStore loadStore(@Nonnull Transaction txn, @Nonnull String schemaName, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) throws RelationalException {
        StoreConfig storeConfig = StoreConfig.create(this.recordLayerConfig, schemaName, this.databasePath, this.metaDataStore, txn, this.options);
        return BackingRecordStore.load(txn, storeConfig, existenceCheck);
    }

    FdbConnection getFDBDatabase() {
        return this.fdbDb;
    }

    @Override
    public BackingRecordStore loadRecordStore(@Nonnull String schemaId, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) throws RelationalException {
        return this.loadStore(this.getCurrentTransaction(), schemaId, existenceCheck);
    }

    @Override
    public URI getURI() {
        return this.databasePath.toUri();
    }
}

