/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.EmbeddedRelationalEngine;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.metrics.NoOpMetricRegistry;
import com.apple.foundationdb.relational.recordlayer.DirectFdbConnection;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RecordLayerStorageCluster;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerMetadataOperationsFactory;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerEngine {
    public static EmbeddedRelationalEngine makeEngine(@Nonnull RecordLayerConfig cfg, @Nonnull List<FDBDatabase> databases, @Nonnull KeySpace baseKeySpace, @Nonnull StoreCatalog schemaCatalog, @Nullable MetricRegistry metricsEngine, @Nonnull RecordLayerMetadataOperationsFactory ddlFactory, @Nullable RelationalPlanCache planCache) {
        MetricRegistry mEngine = RecordLayerEngine.convertToRecordLayerEngine(metricsEngine);
        List<StorageCluster> clusters = databases.stream().map(db -> new RecordLayerStorageCluster(new DirectFdbConnection((FDBDatabase)db, mEngine), baseKeySpace, cfg, schemaCatalog, planCache, ddlFactory)).collect(Collectors.toList());
        return new EmbeddedRelationalEngine(clusters, mEngine);
    }

    private static MetricRegistry convertToRecordLayerEngine(@Nullable MetricRegistry metricsEngine) {
        return Objects.requireNonNullElse(metricsEngine, NoOpMetricRegistry.INSTANCE);
    }

    private RecordLayerEngine() {
    }
}

