/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.ResumableIterator;
import com.apple.foundationdb.relational.recordlayer.util.ExceptionUtil;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class RecordLayerIterator<T>
implements ResumableIterator<Row> {
    private final RecordCursor<T> recordCursor;
    private final Function<T, Row> transform;
    private RecordCursorResult<T> result;
    private Continuation continuation;
    private RecordCursor.NoNextReason noNextReason = null;

    private RecordLayerIterator(@Nonnull RecordCursor<T> cursor, @Nonnull Function<T, Row> transform) throws RelationalException {
        this.recordCursor = cursor;
        this.transform = transform;
        this.continuation = ContinuationImpl.BEGIN;
        this.fetchNextResult();
    }

    public static <T> RecordLayerIterator<T> create(RecordCursor<T> cursor, Function<T, Row> transform) throws RelationalException {
        return new RecordLayerIterator<T>(cursor, transform);
    }

    @Override
    public void close() throws RelationalException {
        try {
            this.recordCursor.close();
        }
        catch (RecordCoreException ex) {
            throw ExceptionUtil.toRelationalException(ex);
        }
    }

    @Override
    public Continuation getContinuation() throws RelationalException {
        this.fetchNextResult();
        return ContinuationImpl.copyOf(this.continuation);
    }

    @Override
    public boolean hasNext() {
        this.fetchNextResult();
        return this.result.hasNext();
    }

    private void fetchNextResult() {
        if (this.result != null) {
            return;
        }
        this.result = this.recordCursor.getNext();
        if (!this.result.hasNext()) {
            this.noNextReason = this.result.getNoNextReason();
            this.continuation = this.noNextReason == RecordCursor.NoNextReason.SOURCE_EXHAUSTED ? ContinuationImpl.END : ContinuationImpl.fromUnderlyingBytes(this.result.getContinuation().toBytes());
        }
    }

    @Override
    public Row next() {
        if (this.hasNext()) {
            try {
                Row row = this.transform.apply(this.result.get());
                this.continuation = ContinuationImpl.fromUnderlyingBytes(this.result.getContinuation().toBytes());
                Row row2 = row;
                return row2;
            }
            catch (RecordCoreException exception) {
                throw ExceptionUtil.toRelationalException(exception).toUncheckedWrappedException();
            }
            finally {
                this.result = null;
            }
        }
        if (this.terminatedEarly()) {
            throw new RelationalException(this.terminatedEarlyReason(), ErrorCode.EXECUTION_LIMIT_REACHED).toUncheckedWrappedException();
        }
        throw new RelationalException("No next row available", ErrorCode.INVALID_CURSOR_STATE).toUncheckedWrappedException();
    }

    @Override
    public boolean terminatedEarly() {
        return !this.hasNext() && this.noNextReason != null && this.noNextReason != RecordCursor.NoNextReason.SOURCE_EXHAUSTED && this.noNextReason != RecordCursor.NoNextReason.RETURN_LIMIT_REACHED;
    }

    @Override
    public RecordCursor.NoNextReason getNoNextReason() {
        return this.noNextReason;
    }

    @Nullable
    private String terminatedEarlyReason() {
        if (!this.terminatedEarly()) {
            return null;
        }
        switch (this.noNextReason) {
            case TIME_LIMIT_REACHED: {
                return "Time Limit allowed for the current transaction is exhausted";
            }
            case BYTE_LIMIT_REACHED: {
                return "Byte Limit allowed for the current transaction is exhausted";
            }
            case SCAN_LIMIT_REACHED: {
                return "Scan Limit allowed for the current transaction is exhausted";
            }
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.recordCursor.isClosed();
    }
}

