/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractRecordLayerResultSet;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.ResumableIterator;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerResultSet
extends AbstractRecordLayerResultSet {
    @Nonnull
    private final ResumableIterator<Row> currentCursor;
    @Nullable
    private final EmbeddedRelationalConnection connection;
    private Row currentRow;
    private volatile boolean closed;
    @Nonnull
    private final EnrichContinuationFunction enrichContinuationFunction;

    public RecordLayerResultSet(@Nonnull StructMetaData metaData, @Nonnull ResumableIterator<Row> iterator, @Nullable EmbeddedRelationalConnection connection) {
        this(metaData, iterator, connection, EnrichContinuationFunction.identity());
    }

    public RecordLayerResultSet(@Nonnull StructMetaData metaData, @Nonnull ResumableIterator<Row> iterator, @Nullable EmbeddedRelationalConnection connection, @Nonnull EnrichContinuationFunction enrichContinuationFunction) {
        super(metaData);
        this.currentCursor = iterator;
        this.connection = connection;
        this.enrichContinuationFunction = enrichContinuationFunction;
    }

    @Override
    protected boolean hasNext() {
        return this.currentCursor.hasNext();
    }

    @Override
    protected Row advanceRow() throws RelationalException {
        this.currentRow = null;
        if (this.currentCursor.hasNext()) {
            try {
                this.currentRow = (Row)this.currentCursor.next();
            }
            catch (UncheckedRelationalException e) {
                throw e.unwrap();
            }
        }
        return this.currentRow;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.currentCursor.close();
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
        if (this.connection != null && this.connection.canCommit() && this.connection.inActiveTransaction()) {
            this.connection.commitInternal();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    @Nonnull
    public Continuation getContinuation() throws SQLException {
        if (this.hasNext()) {
            throw new SQLException("Continuation can only be returned once the result set has been exhausted", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
        try {
            return this.enrichContinuationFunction.apply(this.currentCursor.getContinuation(), this.continuationReason());
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    private Continuation.Reason continuationReason() {
        if (this.currentRow != null) {
            return Continuation.Reason.USER_REQUESTED_CONTINUATION;
        }
        if (this.currentCursor.hasNext()) {
            return Continuation.Reason.USER_REQUESTED_CONTINUATION;
        }
        if (this.currentCursor.terminatedEarly()) {
            return Continuation.Reason.TRANSACTION_LIMIT_REACHED;
        }
        if (this.currentCursor.getNoNextReason().equals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED)) {
            return Continuation.Reason.QUERY_EXECUTION_LIMIT_REACHED;
        }
        return Continuation.Reason.CURSOR_AFTER_LAST;
    }

    @FunctionalInterface
    public static interface EnrichContinuationFunction {
        @Nonnull
        public Continuation apply(@Nonnull Continuation var1, Continuation.Reason var2) throws RelationalException;

        public static EnrichContinuationFunction identity() {
            return (continuation, reason) -> continuation;
        }
    }
}

