/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.ConnectionScoped;
import com.apple.foundationdb.relational.api.catalog.DatabaseSchema;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.AbstractDatabase;
import com.apple.foundationdb.relational.recordlayer.EmbeddedRelationalConnection;
import com.apple.foundationdb.relational.recordlayer.RecordTypeTable;
import com.apple.foundationdb.relational.recordlayer.Table;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.apple.foundationdb.relational.util.Assert;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@ConnectionScoped
@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerSchema
implements DatabaseSchema {
    private final AbstractDatabase db;
    final EmbeddedRelationalConnection conn;
    @Nonnull
    private final String schemaName;
    private final FDBRecordStoreBase.StoreExistenceCheck existenceCheck;
    private BackingStore currentStore;
    private final Map<String, RecordTypeTable> loadedTables = new HashMap<String, RecordTypeTable>();

    public RecordLayerSchema(@Nonnull String schemaName, AbstractDatabase database, EmbeddedRelationalConnection connection) throws RelationalException {
        this.schemaName = schemaName;
        this.db = database;
        this.conn = connection;
        this.existenceCheck = FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_NOT_EXISTS;
    }

    @Override
    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nonnull
    public Table loadTable(@Nonnull String tableName) throws RelationalException {
        RecordTypeTable t2 = this.loadedTables.get(tableName);
        boolean putBack = false;
        if (t2 == null) {
            t2 = new RecordTypeTable(this, tableName);
            putBack = true;
        }
        if (putBack) {
            this.loadedTables.put(tableName, t2);
        }
        return t2;
    }

    @Override
    public void close() throws RelationalException {
        this.currentStore = null;
        for (RecordTypeTable table : this.loadedTables.values()) {
            table.close();
        }
        this.loadedTables.clear();
    }

    @Nonnull
    public BackingStore loadStore() throws RelationalException {
        Assert.thatUnchecked(this.conn.inActiveTransaction(), ErrorCode.INTERNAL_ERROR, "No active transaction!");
        if (this.currentStore != null) {
            return this.currentStore;
        }
        this.currentStore = this.db.loadRecordStore(this.schemaName, this.existenceCheck);
        this.conn.addCloseListener(() -> {
            this.currentStore = null;
        });
        return this.currentStore;
    }
}

