/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.catalog.RelationalDatabase;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.FdbConnection;
import com.apple.foundationdb.relational.recordlayer.RecordLayerConfig;
import com.apple.foundationdb.relational.recordlayer.RecordLayerDatabase;
import com.apple.foundationdb.relational.recordlayer.RelationalKeyspaceProvider;
import com.apple.foundationdb.relational.recordlayer.catalog.CatalogMetaDataStore;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerCatalogQueryFactory;
import com.apple.foundationdb.relational.recordlayer.ddl.RecordLayerMetadataOperationsFactory;
import com.apple.foundationdb.relational.recordlayer.query.cache.RelationalPlanCache;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerStorageCluster
implements StorageCluster {
    private final StoreCatalog catalog;
    private final RecordLayerConfig rlConfiguration;
    private final FdbConnection fdb;
    private final KeySpace keySpace;
    private final RecordLayerMetadataOperationsFactory ddlFactory;
    @Nullable
    private final RelationalPlanCache planCache;

    public RecordLayerStorageCluster(FdbConnection connection, KeySpace keySpace, RecordLayerConfig rlConfig, StoreCatalog storeCatalog, RelationalPlanCache planCache, RecordLayerMetadataOperationsFactory ddlFactory) {
        this.fdb = connection;
        this.keySpace = keySpace;
        this.catalog = storeCatalog;
        this.rlConfiguration = rlConfig;
        this.ddlFactory = ddlFactory;
        this.planCache = planCache;
    }

    private Map<String, String> parseConnectionQueryString(@Nullable String queryStr) {
        String[] connQuery;
        if (queryStr == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> queryFields = new HashMap<String, String>();
        for (String connStr : connQuery = queryStr.split(",")) {
            String[] kvPair = connStr.split("=");
            if (kvPair.length < 2) continue;
            queryFields.put(kvPair[0].toUpperCase(Locale.ROOT), kvPair[1]);
        }
        return queryFields;
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="false positive. https://github.com/spotbugs/spotbugs/issues/1694")
    public RelationalDatabase loadDatabase(@Nonnull URI url, @Nonnull Options connOptions) throws RelationalException {
        String presetSchema;
        block13: {
            Map<String, String> connectionOptions = this.parseConnectionQueryString(url.getQuery());
            presetSchema = connectionOptions.get("SCHEMA");
            try (Transaction txn = this.getTransactionManager().createTransaction(Options.NONE);){
                if (presetSchema != null) {
                    try {
                        this.catalog.loadSchema(txn, url, presetSchema);
                        break block13;
                    }
                    catch (RelationalException ve) {
                        if (ve.getErrorCode() == ErrorCode.UNDEFINED_SCHEMA && !this.catalog.doesDatabaseExist(txn, url)) {
                            RelationalDatabase relationalDatabase = null;
                            if (txn != null) {
                                txn.close();
                            }
                            return relationalDatabase;
                        }
                        throw ve;
                    }
                }
                if (!this.catalog.doesDatabaseExist(txn, url)) {
                    RelationalDatabase ve = null;
                    return ve;
                }
            }
        }
        RelationalKeyspaceProvider.RelationalDatabasePath databasePath = RelationalKeyspaceProvider.toDatabasePath(url, this.keySpace);
        RecordLayerCatalogQueryFactory ddlQueryFactory = new RecordLayerCatalogQueryFactory(this.catalog);
        return new RecordLayerDatabase(this.fdb, new CatalogMetaDataStore(this.catalog), this.catalog, this.rlConfiguration, databasePath, this.ddlFactory, ddlQueryFactory, this.planCache, presetSchema, connOptions);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.fdb.getTransactionManager();
    }
}

