/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.TransactionManager;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.apple.foundationdb.relational.recordlayer.util.MetricRegistryStoreTimer;
import com.codahale.metrics.MetricRegistry;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RecordLayerTransactionManager
implements TransactionManager {
    private final FDBDatabase fdbDb;
    private final MetricRegistry metricRegistry;

    public RecordLayerTransactionManager(FDBDatabase fdbDb, MetricRegistry metricRegistry) {
        this.fdbDb = fdbDb;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public Transaction createTransaction(@Nonnull Options connectionOptions) throws RelationalException {
        return new RecordContextTransaction(this.fdbDb.openContext(this.getFDBRecordContextConfig(connectionOptions, this.metricRegistry)));
    }

    @Override
    public void abort(Transaction txn) throws RelationalException {
        txn.abort();
    }

    @Override
    public void commit(Transaction txn) throws RelationalException {
        txn.commit();
    }

    private FDBRecordContextConfig getFDBRecordContextConfig(@Nonnull Options options, MetricRegistry metricRegistry) {
        FDBRecordContextConfig.Builder builder = FDBRecordContextConfig.newBuilder().setTimer(new MetricRegistryStoreTimer(metricRegistry));
        Long transactionTimeout = (Long)options.getOption(Options.Name.TRANSACTION_TIMEOUT);
        if (transactionTimeout != null) {
            builder.setTransactionTimeoutMillis(transactionTimeout);
        }
        return builder.build();
    }
}

