/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.relational.api.ConnectionScoped;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import com.apple.foundationdb.relational.recordlayer.RecordContextTransaction;
import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.Nonnull;

@ConnectionScoped
@API(value=API.Status.EXPERIMENTAL)
public class RecordStoreAndRecordContextTransaction
implements Transaction {
    FDBRecordStoreBase<Message> store;
    RecordContextTransaction transaction;
    SchemaTemplate boundSchemaTemplate;

    public RecordStoreAndRecordContextTransaction(FDBRecordStoreBase<Message> store, FDBRecordContext context, SchemaTemplate boundSchemaTemplate) {
        this.store = store;
        this.transaction = new RecordContextTransaction(context);
        this.boundSchemaTemplate = boundSchemaTemplate;
    }

    @Override
    public void commit() throws RelationalException {
        this.transaction.commit();
    }

    @Override
    public void abort() throws RelationalException {
        this.transaction.abort();
    }

    @Override
    @Nonnull
    public Optional<SchemaTemplate> getBoundSchemaTemplateMaybe() {
        return this.transaction.getBoundSchemaTemplateMaybe();
    }

    @Override
    public void setBoundSchemaTemplate(@Nonnull SchemaTemplate schemaTemplate) {
        this.transaction.setBoundSchemaTemplate(schemaTemplate);
    }

    @Override
    public void unsetBoundSchemaTemplate() {
        this.transaction.unsetBoundSchemaTemplate();
    }

    @Override
    public void close() throws RelationalException {
        this.transaction.close();
    }

    @Override
    public boolean isClosed() {
        return this.transaction.isClosed();
    }

    public RecordContextTransaction getRecordContextTransaction() {
        return this.transaction;
    }

    public FDBRecordStoreBase<Message> getRecordStore() {
        return this.store;
    }

    @Nonnull
    public SchemaTemplate getBoundSchemaTemplate() {
        return this.boundSchemaTemplate;
    }
}

