/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.recordlayer;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.ddl.ProtobufDdlUtil;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.ImmutableKeyValue;
import com.apple.foundationdb.relational.recordlayer.Index;
import com.apple.foundationdb.relational.recordlayer.KeyBuilder;
import com.apple.foundationdb.relational.recordlayer.RecordLayerSchema;
import com.apple.foundationdb.relational.recordlayer.RecordTypeScannable;
import com.apple.foundationdb.relational.recordlayer.RecordTypeTable;
import com.apple.foundationdb.relational.recordlayer.Table;
import com.apple.foundationdb.relational.recordlayer.TupleUtils;
import com.apple.foundationdb.relational.recordlayer.metadata.DataTypeUtils;
import com.apple.foundationdb.relational.recordlayer.storage.BackingStore;
import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class RecordStoreIndex
extends RecordTypeScannable<IndexEntry>
implements Index {
    private final com.apple.foundationdb.record.metadata.Index index;
    private final RecordTypeTable table;

    public RecordStoreIndex(com.apple.foundationdb.record.metadata.Index index, RecordTypeTable table) {
        this.index = index;
        this.table = table;
    }

    @Override
    public void validate(Options scanOptions) throws RelationalException {
        this.table.loadRecordType(scanOptions);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.index.getName();
    }

    @Override
    public StructMetaData getMetaData() throws RelationalException {
        KeyExpression indexStruct = this.index.getRootExpression();
        RecordType recType = this.table.loadRecordType(Options.NONE);
        List<Descriptors.FieldDescriptor> fields = indexStruct.validate(recType.getDescriptor());
        Type.Record record = ProtobufDdlUtil.recordFromFieldDescriptors(fields);
        return RelationalStructMetaData.of((DataType.StructType)DataTypeUtils.toRelationalType(record));
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void close() throws RelationalException {
    }

    @Override
    public Row get(@Nonnull Transaction t2, @Nonnull Row key, @Nonnull Options options) throws RelationalException {
        BackingStore store = this.getSchema().loadStore();
        return store.getFromIndex(this.index, key, options);
    }

    @Override
    public KeyBuilder getKeyBuilder() throws RelationalException {
        return new KeyBuilder(this.table.loadRecordType(Options.NONE), this.index.getRootExpression(), "index: <" + this.index.getName() + ">");
    }

    @Override
    protected RecordLayerSchema getSchema() {
        return this.table.getSchema();
    }

    @Override
    protected RecordCursor<IndexEntry> openScan(BackingStore store, TupleRange range, @Nullable Continuation continuation, Options options) throws RelationalException {
        return store.scanIndex(this.index, range, continuation, options);
    }

    @Override
    protected Function<IndexEntry, Row> keyValueTransform() {
        return indexEntry -> new ImmutableKeyValue(TupleUtils.toRelationalTuple(indexEntry.getKey()), TupleUtils.toRelationalTuple(indexEntry.getValue()));
    }

    @Override
    protected boolean supportsMessageParsing() {
        return false;
    }

    @Override
    protected boolean hasConstantValueForPrimaryKey(Options options) {
        return this.index.getRootExpression() instanceof RecordTypeKeyExpression;
    }
}

